/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet;

import java.util.ArrayList;
import java.util.List;

public class ServerStatusFlagsUtil {
    public static final int INDEX_SERVER_STATUS_IN_TRANS = 0;
    public static final int INDEX_SERVER_STATUS_AUTOCOMMIT = 1;
    public static final int INDEX_SERVER_MORE_RESULTS_EXISTS = 3;
    public static final int INDEX_SERVER_QUERY_NO_GOOD_INDEX_USED = 4;
    public static final int INDEX_SERVER_QUERY_NO_INDEX_USED = 5;
    public static final int INDEX_SERVER_STATUS_CURSOR_EXISTS = 6;
    public static final int INDEX_SERVER_STATUS_LAST_ROW_SENT = 7;
    public static final int INDEX_SERVER_STATUS_DB_DROPPED = 8;
    public static final int INDEX_SERVER_STATUS_NO_BACKSLASH_ESCAPES = 9;
    public static final int INDEX_SERVER_STATUS_METADATA_CHANGED = 10;
    public static final int INDEX_SERVER_QUERY_WAS_SLOW = 11;
    public static final int INDEX_SERVER_PS_OUT_PARAMS = 12;
    public static final int INDEX_SERVER_STATUS_IN_TRANS_READONLY = 13;
    public static final int INDEX_SERVER_SESSION_STATE_CHANGED = 14;

    public static boolean isServerStatusEnabled(int serverStatusFlags, int serverStatusIndex) throws IllegalArgumentException {
        if (serverStatusIndex < 0 || serverStatusIndex > 15) {
            throw new IllegalArgumentException("Check server status flag failed: `invalid server status index`. `serverStatusFlags`:`" + serverStatusFlags + "`. `serverStatusIndex`:`" + serverStatusIndex + "`.");
        }
        return ((long)serverStatusFlags & 1L << serverStatusIndex) != 0L;
    }

    public static String getServerStatusName(int serverStatusIndex) throws IllegalArgumentException {
        switch (serverStatusIndex) {
            case 0: {
                return "SERVER_STATUS_IN_TRANS";
            }
            case 1: {
                return "SERVER_STATUS_AUTOCOMMIT";
            }
            case 3: {
                return "SERVER_MORE_RESULTS_EXISTS";
            }
            case 4: {
                return "SERVER_QUERY_NO_GOOD_INDEX_USED";
            }
            case 5: {
                return "SERVER_QUERY_NO_INDEX_USED";
            }
            case 6: {
                return "SERVER_STATUS_CURSOR_EXISTS";
            }
            case 7: {
                return "SERVER_STATUS_LAST_ROW_SENT";
            }
            case 8: {
                return "SERVER_STATUS_DB_DROPPED";
            }
            case 9: {
                return "SERVER_STATUS_NO_BACKSLASH_ESCAPES";
            }
            case 10: {
                return "SERVER_STATUS_METADATA_CHANGED";
            }
            case 11: {
                return "SERVER_QUERY_WAS_SLOW";
            }
            case 12: {
                return "SERVER_PS_OUT_PARAMS";
            }
            case 13: {
                return "SERVER_STATUS_IN_TRANS_READONLY";
            }
            case 14: {
                return "SERVER_SESSION_STATE_CHANGED";
            }
        }
        throw new IllegalArgumentException("Get server status name failed: `invalid server status index`. `serverStatusIndex`:`" + serverStatusIndex + "`.");
    }

    public static List<String> getEnabledServerStatusNames(int serverStatusFlags) {
        ArrayList<String> enabledServerStatusNames = new ArrayList<String>();
        for (int i = 0; i < 16; ++i) {
            if (i == 2 || i == 15 || !ServerStatusFlagsUtil.isServerStatusEnabled(serverStatusFlags, i)) continue;
            enabledServerStatusNames.add(ServerStatusFlagsUtil.getServerStatusName(i));
        }
        return enabledServerStatusNames;
    }
}

