/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet.command.text;

import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import java.nio.charset.Charset;

public class CommandQueryPacket {
    private final String sql;

    public CommandQueryPacket(String sql) throws IllegalArgumentException {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("Construct `CommandQueryPacket` failed: `sql is empty`. `invalidSql`:`" + sql + "`.");
        }
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public String toString() {
        return "CommandQueryPacket{sql='" + this.sql + '\'' + '}';
    }

    public byte[] buildMysqlPacketBytes(Charset charset) {
        byte[] sqlBytes = this.sql.getBytes(charset);
        MysqlPacket mysqlPacket = new MysqlPacket(0, new byte[1 + sqlBytes.length]);
        mysqlPacket.writeFixedLengthInteger(1, 3L);
        mysqlPacket.writeFixedLengthBytes(sqlBytes);
        return mysqlPacket.buildMysqlPacketBytes();
    }
}

