/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet.command.text;

import com.heimuheimu.mysql.jdbc.packet.CapabilitiesFlagsUtil;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;

public class TextResultsetResponsePacket {
    private final boolean isMetadataFollows;
    private final int columnCount;

    public TextResultsetResponsePacket(boolean isMetadataFollows, int columnCount) {
        this.isMetadataFollows = isMetadataFollows;
        this.columnCount = columnCount;
    }

    public boolean isMetadataFollows() {
        return this.isMetadataFollows;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public static TextResultsetResponsePacket parse(MysqlPacket packet, long capabilitiesFlags) {
        try {
            packet.setPosition(0);
            boolean isMetadataFollows = true;
            if (CapabilitiesFlagsUtil.isCapabilityEnabled(capabilitiesFlags, 25)) {
                int metadataFollows = (int)packet.readFixedLengthInteger(1);
                isMetadataFollows = metadataFollows != 1;
            }
            return new TextResultsetResponsePacket(isMetadataFollows, (int)packet.readLengthEncodedInteger());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Parse TextResultset failed: `invalid format`. " + packet, e);
        }
    }

    public String toString() {
        return "TextResultsetResponsePacket{isMetadataFollows=" + this.isMetadataFollows + ", columnCount=" + this.columnCount + '}';
    }
}

