/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet.command.text;

import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class TextResultsetRowResponsePacket {
    private final List<byte[]> columnsValues = new ArrayList<byte[]>();

    public void addColumnValue(byte[] columnValue) {
        this.columnsValues.add(columnValue);
    }

    public List<byte[]> getColumnsValues() {
        return this.columnsValues;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("TextResultsetRowResponsePacket{columnsValues=[");
        if (!this.columnsValues.isEmpty()) {
            for (byte[] value : this.columnsValues) {
                if (value != null) {
                    buffer.append("\"").append(new String(value, StandardCharsets.UTF_8)).append("\", ");
                    continue;
                }
                buffer.append("null, ");
            }
            buffer.delete(buffer.length() - 2, buffer.length());
        }
        buffer.append("]}");
        return buffer.toString();
    }

    public static TextResultsetRowResponsePacket parse(MysqlPacket packet) {
        try {
            packet.setPosition(0);
            TextResultsetRowResponsePacket textResultsetRowResponsePacket = new TextResultsetRowResponsePacket();
            while (packet.hasRemaining()) {
                int valueBytesLength = (int)packet.readLengthEncodedInteger();
                if (valueBytesLength != -1) {
                    textResultsetRowResponsePacket.addColumnValue(packet.readFixedLengthBytes(valueBytesLength));
                    continue;
                }
                textResultsetRowResponsePacket.addColumnValue(null);
            }
            return textResultsetRowResponsePacket;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Parse TextResultsetRowResponsePacket failed: `invalid format`. " + packet, e);
        }
    }
}

