/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet.connection;

import com.heimuheimu.mysql.jdbc.packet.CapabilitiesFlagsUtil;
import com.heimuheimu.mysql.jdbc.packet.CharsetMappingUtil;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;

public class HandshakeResponse41Packet {
    private static final int MAX_PACKET_SIZE = 0xFFFFFF;
    private long capabilitiesFlags = 0L;
    private int clientCharacterId = 45;
    private String username = "";
    private byte[] authResponse = null;
    private String databaseName = "";
    private String authPluginName = "";
    private final LinkedHashMap<String, String> clientConnectionAttributeMap = new LinkedHashMap();

    public long getCapabilitiesFlags() {
        return this.capabilitiesFlags;
    }

    public void setCapabilitiesFlags(long capabilitiesFlags) {
        this.capabilitiesFlags = capabilitiesFlags;
    }

    public int getClientCharacterId() {
        return this.clientCharacterId;
    }

    public void setClientCharacterId(int clientCharacterId) throws IllegalArgumentException {
        if (clientCharacterId < 0 || clientCharacterId > 255) {
            throw new IllegalArgumentException("Set client character id failed: `out of range`. `invalidClientCharacterId`:`" + clientCharacterId + "`. " + this);
        }
        this.clientCharacterId = clientCharacterId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) throws IllegalArgumentException {
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("Set username failed: `username should not be empty`. " + this);
        }
        this.username = username;
    }

    public byte[] getAuthResponse() {
        return this.authResponse;
    }

    public void setAuthResponse(byte[] authResponse) throws NullPointerException {
        if (authResponse == null) {
            throw new NullPointerException("Set auth response failed: `authResponse should not be null`. " + this);
        }
        this.authResponse = authResponse;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getAuthPluginName() {
        return this.authPluginName;
    }

    public void setAuthPluginName(String authPluginName) throws IllegalArgumentException {
        if (authPluginName == null || authPluginName.isEmpty()) {
            throw new IllegalArgumentException("Set auth plugin name failed: `authPluginName should not be empty`. " + this);
        }
        this.authPluginName = authPluginName;
    }

    public LinkedHashMap<String, String> getClientConnectionAttributeMap() {
        return this.clientConnectionAttributeMap;
    }

    public void addClientConnectionAttribute(String key, String value) throws IllegalArgumentException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Add client connection attribute failed: `key should not be empty`. `key`:`" + key + "`. `value`:`" + value + "`. " + this);
        }
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Add client connection attribute failed: `value should not be empty`. `key`:`" + key + "`. `value`:`" + value + "`. " + this);
        }
        this.clientConnectionAttributeMap.put(key, value);
    }

    public byte[] buildMysqlPacketBytes(long serverCapabilitiesFlags) throws IllegalArgumentException, IllegalStateException {
        byte[] authPluginNameBytes;
        byte[] usernameBytes;
        this.initializeCapabilitiesFlags(serverCapabilitiesFlags);
        Charset charset = CharsetMappingUtil.getJavaCharset(this.clientCharacterId);
        int mysqlPacketPayloadLength = 32;
        if (this.username != null && !this.username.isEmpty()) {
            usernameBytes = this.username.getBytes(charset);
            mysqlPacketPayloadLength += usernameBytes.length + 1;
        } else {
            throw new IllegalArgumentException("Build `HandshakeResponse41` packet failed: `username is empty`. " + this);
        }
        if (this.authResponse != null) {
            mysqlPacketPayloadLength += this.authResponse.length + 9;
        } else {
            throw new IllegalArgumentException("Build `HandshakeResponse41` packet failed: `authResponse is null`. " + this);
        }
        byte[] databaseNameBytes = new byte[]{};
        if (this.databaseName != null && !this.databaseName.isEmpty()) {
            databaseNameBytes = this.databaseName.getBytes(charset);
            mysqlPacketPayloadLength += databaseNameBytes.length + 1;
        }
        if (this.authPluginName != null && !this.authPluginName.isEmpty()) {
            authPluginNameBytes = this.authPluginName.getBytes(StandardCharsets.UTF_8);
            mysqlPacketPayloadLength += authPluginNameBytes.length + 1;
        } else {
            throw new IllegalArgumentException("Build `HandshakeResponse41` packet failed: `authPluginName is empty`. " + this);
        }
        Object clientConnectionAttributeBytes = null;
        int bytesLengthOfAllAttributes = 0;
        if (CapabilitiesFlagsUtil.isCapabilityEnabled(this.capabilitiesFlags, 20)) {
            clientConnectionAttributeBytes = new byte[this.clientConnectionAttributeMap.size() * 2][];
            int attributeBytesIndex = 0;
            for (String key : this.clientConnectionAttributeMap.keySet()) {
                byte[] attributeKeyBytes = key.getBytes(charset);
                byte[] attributeValueBytes = this.clientConnectionAttributeMap.get(key).getBytes(charset);
                clientConnectionAttributeBytes[attributeBytesIndex++] = attributeKeyBytes;
                clientConnectionAttributeBytes[attributeBytesIndex++] = attributeValueBytes;
                bytesLengthOfAllAttributes += attributeKeyBytes.length + MysqlPacket.getBytesLengthForLengthEncodedInteger(attributeKeyBytes.length);
                bytesLengthOfAllAttributes += attributeValueBytes.length + MysqlPacket.getBytesLengthForLengthEncodedInteger(attributeValueBytes.length);
            }
            mysqlPacketPayloadLength += bytesLengthOfAllAttributes + 9;
        }
        MysqlPacket handshakeResponse41Packet = new MysqlPacket(1, new byte[mysqlPacketPayloadLength]);
        handshakeResponse41Packet.writeFixedLengthInteger(4, this.capabilitiesFlags);
        handshakeResponse41Packet.writeFixedLengthInteger(4, 0xFFFFFFL);
        handshakeResponse41Packet.writeFixedLengthInteger(1, this.clientCharacterId);
        handshakeResponse41Packet.setPosition(handshakeResponse41Packet.getPosition() + 23);
        handshakeResponse41Packet.writeNullTerminatedString(usernameBytes);
        if (CapabilitiesFlagsUtil.isCapabilityEnabled(this.capabilitiesFlags, 21)) {
            handshakeResponse41Packet.writeLengthEncodedString(this.authResponse);
        } else {
            handshakeResponse41Packet.writeFixedLengthInteger(1, this.authResponse.length);
            handshakeResponse41Packet.writeFixedLengthBytes(this.authResponse);
        }
        if (CapabilitiesFlagsUtil.isCapabilityEnabled(this.capabilitiesFlags, 3)) {
            handshakeResponse41Packet.writeNullTerminatedString(databaseNameBytes);
        }
        if (CapabilitiesFlagsUtil.isCapabilityEnabled(this.capabilitiesFlags, 19)) {
            handshakeResponse41Packet.writeNullTerminatedString(authPluginNameBytes);
        }
        if (clientConnectionAttributeBytes != null) {
            handshakeResponse41Packet.writeLengthEncodedInteger(bytesLengthOfAllAttributes);
            for (int i = 0; i < ((byte[][])clientConnectionAttributeBytes).length; ++i) {
                handshakeResponse41Packet.writeLengthEncodedString(clientConnectionAttributeBytes[i]);
            }
        }
        return handshakeResponse41Packet.buildMysqlPacketBytes();
    }

    private void initializeCapabilitiesFlags(long serverCapabilitiesFlags) {
        this.capabilitiesFlags = CapabilitiesFlagsUtil.disableCapability(this.capabilitiesFlags, 24);
        this.enableClientCapability(serverCapabilitiesFlags, 9, true);
        this.enableClientCapability(serverCapabilitiesFlags, 19, true);
        this.enableClientCapability(serverCapabilitiesFlags, 14, false);
        this.enableClientCapability(serverCapabilitiesFlags, 15, true);
        this.enableClientCapability(serverCapabilitiesFlags, 21, false);
        if (!this.clientConnectionAttributeMap.isEmpty()) {
            this.enableClientCapability(serverCapabilitiesFlags, 20, false);
        }
        if (this.databaseName != null && !this.databaseName.isEmpty()) {
            this.enableClientCapability(serverCapabilitiesFlags, 3, true);
        }
        long clientCapabilitiesFlags = 0L;
        for (int i = 0; i < 32; ++i) {
            if (!CapabilitiesFlagsUtil.isCapabilityEnabled(serverCapabilitiesFlags, i) || !CapabilitiesFlagsUtil.isCapabilityEnabled(this.capabilitiesFlags, i)) continue;
            clientCapabilitiesFlags = CapabilitiesFlagsUtil.enableCapability(clientCapabilitiesFlags, i);
        }
        this.capabilitiesFlags = clientCapabilitiesFlags;
    }

    private void enableClientCapability(long serverCapabilitiesFlags, int capabilityIndex, boolean required) throws IllegalStateException {
        if (CapabilitiesFlagsUtil.isCapabilityEnabled(serverCapabilitiesFlags, capabilityIndex)) {
            this.capabilitiesFlags = CapabilitiesFlagsUtil.enableCapability(this.capabilitiesFlags, capabilityIndex);
        } else if (required) {
            throw new IllegalStateException("Enable capability `" + CapabilitiesFlagsUtil.getCapabilityName(capabilityIndex) + "` failed: `the capability is disabled at mysql server side`. `capabilityIndex`:`" + capabilityIndex + "`. `serverCapabilitiesFlags`:`" + serverCapabilitiesFlags + "`. " + this);
        }
    }

    public String toString() {
        return "HandshakeResponse41Packet{capabilitiesFlags=" + this.capabilitiesFlags + ", clientCharacterId=" + this.clientCharacterId + ", username='" + this.username + '\'' + ", authResponse=" + Arrays.toString(this.authResponse) + ", databaseName='" + this.databaseName + '\'' + ", authPluginName='" + this.authPluginName + '\'' + ", clientConnectionAttributeMap=" + this.clientConnectionAttributeMap + '}';
    }
}

