/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet.connection;

import com.heimuheimu.mysql.jdbc.packet.CapabilitiesFlagsUtil;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class HandshakeV10Packet {
    private String serverVersion = "";
    private long connectionId = -1L;
    private int serverCharacterId = -1;
    private int serverStatusFlags = 0;
    private long capabilitiesFlags = 0L;
    private String authPluginName = null;
    private byte[] authPluginData = null;

    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(long connectionId) {
        this.connectionId = connectionId;
    }

    public int getServerCharacterId() {
        return this.serverCharacterId;
    }

    public void setServerCharacterId(int serverCharacterId) {
        this.serverCharacterId = serverCharacterId;
    }

    public int getServerStatusFlags() {
        return this.serverStatusFlags;
    }

    public void setServerStatusFlags(int serverStatusFlags) {
        this.serverStatusFlags = serverStatusFlags;
    }

    public long getCapabilitiesFlags() {
        return this.capabilitiesFlags;
    }

    public void setCapabilitiesFlags(long capabilitiesFlags) {
        this.capabilitiesFlags = capabilitiesFlags;
    }

    public String getAuthPluginName() {
        return this.authPluginName;
    }

    public void setAuthPluginName(String authPluginName) {
        this.authPluginName = authPluginName;
    }

    public byte[] getAuthPluginData() {
        return this.authPluginData;
    }

    public void setAuthPluginData(byte[] authPluginData) {
        this.authPluginData = authPluginData;
    }

    public String toString() {
        return "HandshakeV10Packet{serverVersion='" + this.serverVersion + '\'' + ", connectionId=" + this.connectionId + ", serverCharacterId=" + this.serverCharacterId + ", serverStatusFlags=" + this.serverStatusFlags + ", capabilitiesFlags=" + this.capabilitiesFlags + ", authPluginName='" + this.authPluginName + '\'' + ", authPluginData=" + Arrays.toString(this.authPluginData) + '}';
    }

    public static HandshakeV10Packet parse(MysqlPacket packet) throws IllegalArgumentException {
        packet.setPosition(0);
        HandshakeV10Packet handshakeV10Packet = new HandshakeV10Packet();
        long protocolVersion = packet.readFixedLengthInteger(1);
        if (protocolVersion != 10L) {
            throw new IllegalArgumentException("Invalid HandshakeV10Packet protocol version: `" + protocolVersion + "`. Expected value: `10`. " + packet);
        }
        handshakeV10Packet.setServerVersion(packet.readNullTerminatedString(StandardCharsets.US_ASCII));
        handshakeV10Packet.setConnectionId(packet.readFixedLengthInteger(4));
        byte[] authPluginDataPart1 = packet.readFixedLengthBytes(8);
        long filter = packet.readFixedLengthInteger(1);
        if (filter != 0L) {
            throw new IllegalArgumentException("Invalid HandshakeV10Packet filter: `0x" + Long.toString(filter, 16) + "`. Expected value: `0x00`. " + packet);
        }
        long capabilitiesFlags = packet.readFixedLengthInteger(2);
        handshakeV10Packet.setServerCharacterId((int)packet.readFixedLengthInteger(1));
        handshakeV10Packet.setServerStatusFlags((int)packet.readFixedLengthInteger(2));
        handshakeV10Packet.setCapabilitiesFlags(capabilitiesFlags |= packet.readFixedLengthInteger(2) << 16);
        int authPluginDataLength = 0;
        if (CapabilitiesFlagsUtil.isCapabilityEnabled(capabilitiesFlags, 19)) {
            authPluginDataLength = (int)packet.readFixedLengthInteger(1);
        } else {
            long constantAuthPluginDataLength = packet.readFixedLengthInteger(1);
            if (constantAuthPluginDataLength != 0L) {
                throw new IllegalArgumentException("Invalid HandshakeV10Packet auth plugin data length constant value: `0x" + Long.toString(constantAuthPluginDataLength, 16) + "`. Expected value: `0x00`. " + packet);
            }
        }
        packet.setPosition(packet.getPosition() + 10);
        authPluginDataLength = Math.max(13, authPluginDataLength - 8);
        byte[] authPluginDataPart2 = packet.readFixedLengthBytes(authPluginDataLength);
        if (CapabilitiesFlagsUtil.isCapabilityEnabled(capabilitiesFlags, 19)) {
            byte[] authPluginData = new byte[authPluginDataPart1.length + authPluginDataPart2.length];
            System.arraycopy(authPluginDataPart1, 0, authPluginData, 0, authPluginDataPart1.length);
            System.arraycopy(authPluginDataPart2, 0, authPluginData, authPluginDataPart1.length, authPluginDataPart2.length);
            handshakeV10Packet.setAuthPluginData(authPluginData);
            String restOfPacketString = packet.readRestOfPacketString(StandardCharsets.UTF_8);
            int nullTerminatedIndex = restOfPacketString.indexOf(0);
            if (nullTerminatedIndex < 0) {
                handshakeV10Packet.setAuthPluginName(restOfPacketString);
            } else {
                handshakeV10Packet.setAuthPluginName(restOfPacketString.substring(0, nullTerminatedIndex));
            }
        }
        return handshakeV10Packet;
    }
}

