/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet.connection.auth;

import com.heimuheimu.mysql.jdbc.packet.connection.auth.AuthenticationPlugin;
import com.heimuheimu.mysql.jdbc.packet.connection.auth.MysqlNativePasswordAuthPlugin;
import java.util.HashMap;
import java.util.Map;

public class AuthenticationPluginFactory {
    private static final Map<String, AuthenticationPlugin> AUTHENTICATION_PLUGIN_MAP = new HashMap<String, AuthenticationPlugin>();

    public static AuthenticationPlugin get(String authPluginName) throws IllegalArgumentException {
        AuthenticationPlugin plugin = AUTHENTICATION_PLUGIN_MAP.get(authPluginName);
        if (plugin == null) {
            throw new IllegalArgumentException("There is no authentication plugin for name: `" + authPluginName + "`.");
        }
        return plugin;
    }

    static {
        MysqlNativePasswordAuthPlugin mysqlNativePasswordAuthPlugin = new MysqlNativePasswordAuthPlugin();
        AUTHENTICATION_PLUGIN_MAP.put(mysqlNativePasswordAuthPlugin.getName(), mysqlNativePasswordAuthPlugin);
    }
}

