/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet.connection.auth;

import com.heimuheimu.mysql.jdbc.packet.connection.auth.AuthenticationPlugin;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;

public class MysqlNativePasswordAuthPlugin
implements AuthenticationPlugin {
    private static final int AUTH_PLUGIN_DATA_LENGTH = 20;

    @Override
    public String getName() {
        return "mysql_native_password";
    }

    @Override
    public byte[] encode(String password, byte[] authPluginData) throws IllegalArgumentException {
        if (password == null || password.isEmpty()) {
            return new byte[0];
        }
        if (authPluginData.length < 20) {
            throw new IllegalArgumentException("Encode password failed: `insufficient auth plugin data`. `authPluginData`:`" + Arrays.toString(authPluginData) + "`.");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] passwordHashStage1 = md.digest(password.getBytes(StandardCharsets.UTF_8));
            md.reset();
            byte[] passwordHashStage2 = md.digest(passwordHashStage1);
            md.reset();
            md.update(authPluginData, 0, 20);
            md.update(passwordHashStage2);
            byte[] encodedBytes = md.digest();
            for (int i = 0; i < encodedBytes.length; ++i) {
                encodedBytes[i] = (byte)(encodedBytes[i] ^ passwordHashStage1[i]);
            }
            return encodedBytes;
        }
        catch (Exception e) {
            throw new RuntimeException("Encode password failed: `" + e.getMessage() + "`. `authPluginData`:`" + Arrays.toString(authPluginData) + "`.", e);
        }
    }
}

