/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet.generic;

import com.heimuheimu.mysql.jdbc.packet.CapabilitiesFlagsUtil;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;

public class EOFPacket {
    private final int serverStatusFlags;
    private final int warnings;

    public EOFPacket(int serverStatusFlags, int warnings) {
        this.serverStatusFlags = serverStatusFlags;
        this.warnings = warnings;
    }

    public int getServerStatusFlags() {
        return this.serverStatusFlags;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public String toString() {
        return "EOFPacket{serverStatusFlags=" + this.serverStatusFlags + ", warnings=" + this.warnings + '}';
    }

    public static boolean isEOFPacket(MysqlPacket packet) {
        if (packet.getPayload().length < 9) {
            int initialPosition = packet.getPosition();
            packet.setPosition(0);
            int firstByte = (int)packet.readFixedLengthInteger(1);
            packet.setPosition(initialPosition);
            return firstByte == 254;
        }
        return false;
    }

    public static EOFPacket parse(MysqlPacket packet, long capabilitiesFlags) throws IllegalArgumentException {
        if (EOFPacket.isEOFPacket(packet)) {
            try {
                packet.setPosition(1);
                int warnings = 0;
                int serverStatusFlags = -1;
                if (CapabilitiesFlagsUtil.isCapabilityEnabled(capabilitiesFlags, 9)) {
                    warnings = (int)packet.readFixedLengthInteger(2);
                    serverStatusFlags = (int)packet.readFixedLengthInteger(2);
                }
                return new EOFPacket(serverStatusFlags, warnings);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Parse EOF_Packet failed: `invalid format`. " + packet, e);
            }
        }
        throw new IllegalArgumentException("Parse EOF_Packet failed: `invalid first byte[0x" + Integer.toString(packet.getPayload()[0], 16) + "]`. Expected value: `0xFE`. " + packet);
    }
}

