/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet.generic;

import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import java.nio.charset.Charset;

public class ErrorPacket {
    private final int errorCode;
    private final String sqlState;
    private final String errorMessage;

    public ErrorPacket(int errorCode, String sqlState, String errorMessage) {
        this.errorCode = errorCode;
        this.sqlState = sqlState;
        this.errorMessage = errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "ErrorPacket{errorCode=" + this.errorCode + ", sqlState='" + this.sqlState + '\'' + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static boolean isErrorPacket(MysqlPacket packet) {
        int initialPosition = packet.getPosition();
        packet.setPosition(0);
        int firstByte = (int)packet.readFixedLengthInteger(1);
        packet.setPosition(initialPosition);
        return firstByte == 255;
    }

    public static ErrorPacket parse(MysqlPacket packet, Charset charset) throws IllegalArgumentException {
        if (ErrorPacket.isErrorPacket(packet)) {
            try {
                String errorMessage;
                String sqlState;
                packet.setPosition(1);
                int errorCode = (int)packet.readFixedLengthInteger(2);
                String restOfPacketString = packet.readRestOfPacketString(charset);
                if (restOfPacketString.charAt(0) == '#' && restOfPacketString.length() > 6) {
                    sqlState = restOfPacketString.substring(1, 6);
                    errorMessage = restOfPacketString.substring(6);
                } else {
                    sqlState = "";
                    errorMessage = restOfPacketString;
                }
                return new ErrorPacket(errorCode, sqlState, errorMessage);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Parse ERR_Packet failed: `invalid format`. " + packet, e);
            }
        }
        throw new IllegalArgumentException("Parse ERR_Packet failed: `invalid first byte[0x" + Integer.toString(packet.getPayload()[0], 16) + "]`. Expected value: `0xFF`. " + packet);
    }
}

