/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.packet.generic;

import com.heimuheimu.mysql.jdbc.packet.CapabilitiesFlagsUtil;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import com.heimuheimu.mysql.jdbc.packet.ServerStatusFlagsUtil;
import java.nio.charset.Charset;

public class OKPacket {
    private long affectedRows = 0L;
    private long lastInsertId = -1L;
    private int serverStatusFlags = -1;
    private int warnings = 0;
    private String info = "";
    private String sessionStateInfo = "";

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public void setAffectedRows(long affectedRows) {
        this.affectedRows = affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }

    public void setLastInsertId(long lastInsertId) {
        this.lastInsertId = lastInsertId;
    }

    public int getServerStatusFlags() {
        return this.serverStatusFlags;
    }

    public void setServerStatusFlags(int serverStatusFlags) {
        this.serverStatusFlags = serverStatusFlags;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public void setWarnings(int warnings) {
        this.warnings = warnings;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getSessionStateInfo() {
        return this.sessionStateInfo;
    }

    public void setSessionStateInfo(String sessionStateInfo) {
        this.sessionStateInfo = sessionStateInfo;
    }

    public String toString() {
        return "OKPacket{affectedRows=" + this.affectedRows + ", lastInsertId=" + this.lastInsertId + ", serverStatusFlags=" + this.serverStatusFlags + ", warnings=" + this.warnings + ", info='" + this.info + '\'' + ", sessionStateInfo='" + this.sessionStateInfo + '\'' + '}';
    }

    public static boolean isOkPacket(MysqlPacket packet) {
        if (packet.getPayload().length >= 7) {
            int initialPosition = packet.getPosition();
            packet.setPosition(0);
            int firstByte = (int)packet.readFixedLengthInteger(1);
            packet.setPosition(initialPosition);
            return firstByte == 0 || firstByte == 254;
        }
        return false;
    }

    public static OKPacket parse(MysqlPacket packet, long capabilitiesFlags, Charset charset) {
        if (OKPacket.isOkPacket(packet)) {
            try {
                packet.setPosition(1);
                OKPacket okPacket = new OKPacket();
                okPacket.setAffectedRows(packet.readLengthEncodedInteger());
                okPacket.setLastInsertId(packet.readLengthEncodedInteger());
                if (CapabilitiesFlagsUtil.isCapabilityEnabled(capabilitiesFlags, 9)) {
                    okPacket.setServerStatusFlags((int)packet.readFixedLengthInteger(2));
                    okPacket.setWarnings((int)packet.readFixedLengthInteger(2));
                } else if (CapabilitiesFlagsUtil.isCapabilityEnabled(capabilitiesFlags, 13)) {
                    okPacket.setServerStatusFlags((int)packet.readFixedLengthInteger(2));
                }
                if (packet.hasRemaining()) {
                    if (CapabilitiesFlagsUtil.isCapabilityEnabled(capabilitiesFlags, 23)) {
                        okPacket.setInfo(packet.readLengthEncodedString(charset));
                        if (packet.hasRemaining() && ServerStatusFlagsUtil.isServerStatusEnabled(okPacket.getServerStatusFlags(), 14)) {
                            okPacket.setSessionStateInfo(packet.readLengthEncodedString(charset));
                        }
                    } else {
                        okPacket.setInfo(packet.readRestOfPacketString(charset));
                    }
                }
                return okPacket;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Parse OK_Packet failed: `invalid format`. " + packet, e);
            }
        }
        throw new IllegalArgumentException("Parse OK_Packet failed: `invalid first byte[0x" + Integer.toString(packet.getPayload()[0], 16) + "]`. Expected value: `0x00 or 0xFE`. " + packet);
    }
}

