/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.result;

import com.heimuheimu.mysql.jdbc.facility.SQLFeatureNotSupportedExceptionBuilder;
import com.heimuheimu.mysql.jdbc.result.AutoGenerateKeysResultSetMetaData;
import com.heimuheimu.mysql.jdbc.result.ReadonlyScrollResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoGenerateKeysResultSet
extends ReadonlyScrollResultSet {
    private static final Logger LOG = LoggerFactory.getLogger(AutoGenerateKeysResultSet.class);
    private final List<Long> autoGenerateKeyList = new ArrayList<Long>();
    private final Statement statement;

    public AutoGenerateKeysResultSet(long autoGenerateKey, Statement statement) {
        if (autoGenerateKey != -1L) {
            this.autoGenerateKeyList.add(autoGenerateKey);
        }
        this.statement = statement;
    }

    @Override
    public int getRowsSize() {
        return this.autoGenerateKeyList.size();
    }

    @Override
    public void close() {
    }

    private long getAutoGenerateKey() throws SQLException {
        int currentRow = this.getRow();
        if (currentRow >= 1 && currentRow <= this.getRowsSize()) {
            return this.autoGenerateKeyList.get(currentRow - 1);
        }
        String errorMessage = "Get auto generate key failed: `invalid row`. Current row: `" + currentRow + "`. Rows size: `" + this.getRowsSize() + "`.";
        LOG.error(errorMessage);
        throw new SQLException(errorMessage);
    }

    @Override
    public boolean wasNull() {
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return String.valueOf(this.getAutoGenerateKey());
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return String.valueOf(this.getAutoGenerateKey());
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (short)this.getAutoGenerateKey();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return (short)this.getAutoGenerateKey();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return (int)this.getAutoGenerateKey();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return (int)this.getAutoGenerateKey();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getAutoGenerateKey();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getAutoGenerateKey();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getAutoGenerateKey();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getAutoGenerateKey();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getAutoGenerateKey();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getAutoGenerateKey();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return new BigDecimal(this.getAutoGenerateKey());
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return new BigDecimal(this.getAutoGenerateKey());
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getAutoGenerateKey();
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getAutoGenerateKey();
    }

    @Override
    public int findColumn(String columnLabel) {
        return 1;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new AutoGenerateKeysResultSetMetaData();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getBoolean(int columnIndex)");
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getBoolean(String columnLabel)");
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getByte(int columnIndex)");
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getByte(String columnLabel)");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getBytes(int columnIndex)");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getDate(int columnIndex)");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getTime(int columnIndex)");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getTimestamp(int columnIndex)");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getAsciiStream(int columnIndex)");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getUnicodeStream(int columnIndex)");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getBinaryStream(int columnIndex)");
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getBytes(String columnLabel)");
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getDate(String columnLabel)");
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getTime(String columnLabel)");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getTimestamp(String columnLabel)");
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getAsciiStream(String columnLabel)");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getUnicodeStream(String columnLabel)");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getBinaryStream(String columnLabel)");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getCursorName()");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getCharacterStream(int columnIndex)");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getCharacterStream(String columnLabel)");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getBigDecimal(int columnIndex)");
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getBigDecimal(String columnLabel)");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getObject(int columnIndex, Map<String, Class<?>> map)");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getRef(int columnIndex)");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getBlob(int columnIndex)");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getClob(int columnIndex)");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getArray(int columnIndex)");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getObject(String columnLabel, Map<String, Class<?>> map)");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getRef(String columnLabel)");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getBlob(String columnLabel)");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getClob(String columnLabel)");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getArray(String columnLabel)");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getDate(int columnIndex, Calendar cal)");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getDate(String columnLabel, Calendar cal)");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getTime(int columnIndex, Calendar cal)");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getTime(String columnLabel, Calendar cal)");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getTimestamp(int columnIndex, Calendar cal)");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getTimestamp(String columnLabel, Calendar cal)");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getURL(int columnIndex)");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getURL(String columnLabel)");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getRowId(int columnIndex)");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getRowId(String columnLabel)");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getHoldability()");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getNClob(int columnIndex)");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getNClob(String columnLabel)");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getSQLXML(int columnIndex)");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getSQLXML(String columnLabel)");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getNString(int columnIndex)");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getNString(String columnLabel)");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getNCharacterStream(int columnIndex)");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getNCharacterStream(String columnLabel)");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getObject(int columnIndex, Class<T> type)");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("AutoGenerateKeysResultSet#getObject(String columnLabel, Class<T> type)");
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return AutoGenerateKeysResultSet.class == iface;
    }
}

