/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.result;

import com.heimuheimu.mysql.jdbc.result.ReadonlyResultSet;
import java.sql.SQLException;

public abstract class ReadonlyScrollResultSet
extends ReadonlyResultSet {
    private int fetchDirection = 1000;
    private int currentRow = 0;

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public boolean isBeforeFirst() {
        int rowsSize = this.getRowsSize();
        if (rowsSize > 0) {
            return this.currentRow == 0;
        }
        return false;
    }

    @Override
    public boolean isAfterLast() {
        int rowsSize = this.getRowsSize();
        if (rowsSize > 0) {
            return this.currentRow == rowsSize + 1;
        }
        return false;
    }

    @Override
    public boolean isFirst() {
        return this.currentRow == 1;
    }

    @Override
    public boolean isLast() {
        int rowsSize = this.getRowsSize();
        if (rowsSize > 0) {
            return this.currentRow == rowsSize;
        }
        return false;
    }

    @Override
    public void beforeFirst() {
        int rowsSize = this.getRowsSize();
        if (rowsSize > 0) {
            this.currentRow = 0;
        }
    }

    @Override
    public void afterLast() {
        int rowsSize = this.getRowsSize();
        if (rowsSize > 0) {
            this.currentRow = rowsSize + 1;
        }
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public int getRow() {
        int rowsSize = this.getRowsSize();
        if (this.currentRow > 0 && this.currentRow <= rowsSize) {
            return this.currentRow;
        }
        return 0;
    }

    @Override
    public boolean absolute(int row) {
        int rowsSize = this.getRowsSize();
        if (rowsSize > 0) {
            if (row < 0) {
                row = rowsSize + 1 + row;
            }
            row = Math.max(0, row);
            this.currentRow = row = Math.min(rowsSize + 1, row);
            return this.currentRow > 0 && this.currentRow <= rowsSize;
        }
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        int targetRow = this.currentRow + rows;
        targetRow = Math.max(0, targetRow);
        return this.absolute(targetRow);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    public void setFetchDirection(int direction) {
        this.fetchDirection = direction == 1001 ? 1001 : 1000;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() {
        return this.getRowsSize();
    }

    @Override
    public int getType() {
        return 1004;
    }

    public abstract int getRowsSize();
}

