/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.result;

import com.heimuheimu.mysql.jdbc.ConnectionInfo;
import com.heimuheimu.mysql.jdbc.facility.SQLFeatureNotSupportedExceptionBuilder;
import com.heimuheimu.mysql.jdbc.packet.ColumnTypeMappingUtil;
import com.heimuheimu.mysql.jdbc.packet.MysqlPacket;
import com.heimuheimu.mysql.jdbc.packet.command.text.ColumnDefinition41ResponsePacket;
import com.heimuheimu.mysql.jdbc.packet.command.text.TextResultsetResponsePacket;
import com.heimuheimu.mysql.jdbc.packet.command.text.TextResultsetRowResponsePacket;
import com.heimuheimu.mysql.jdbc.packet.generic.EOFPacket;
import com.heimuheimu.mysql.jdbc.result.ReadonlyScrollResultSet;
import com.heimuheimu.mysql.jdbc.result.TextResultSetMetaData;
import com.heimuheimu.naivemonitor.monitor.ExecutionMonitor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadonlyTextResultSet
extends ReadonlyScrollResultSet {
    private static final Logger LOG = LoggerFactory.getLogger(ReadonlyTextResultSet.class);
    private final List<ColumnDefinition41ResponsePacket> columnDefinition41ResponsePacketList;
    private final Map<String, Integer> columnIndexMap;
    private final List<TextResultsetRowResponsePacket> textResultsetRowResponsePacketList;
    private final ConnectionInfo connectionInfo;
    private final Statement statement;
    private final ExecutionMonitor executionMonitor;
    private final int rowsSize;
    private boolean wasNull = false;

    public ReadonlyTextResultSet(List<MysqlPacket> mysqlPackets, ConnectionInfo connectionInfo, Statement statement, ExecutionMonitor executionMonitor) throws IllegalArgumentException {
        this.connectionInfo = connectionInfo;
        this.statement = statement;
        this.executionMonitor = executionMonitor;
        int i = 0;
        TextResultsetResponsePacket textResultsetResponsePacket = TextResultsetResponsePacket.parse(mysqlPackets.get(i++), connectionInfo.getCapabilitiesFlags());
        this.columnIndexMap = new HashMap<String, Integer>();
        this.columnDefinition41ResponsePacketList = new ArrayList<ColumnDefinition41ResponsePacket>();
        if (textResultsetResponsePacket.isMetadataFollows()) {
            for (int j = 0; j < textResultsetResponsePacket.getColumnCount(); ++j) {
                ColumnDefinition41ResponsePacket columnDefinition41 = ColumnDefinition41ResponsePacket.parse(mysqlPackets.get(i++), connectionInfo.getJavaCharset());
                this.columnIndexMap.put(columnDefinition41.getColumnName(), j + 1);
                this.columnDefinition41ResponsePacketList.add(columnDefinition41);
            }
        }
        this.textResultsetRowResponsePacketList = new ArrayList<TextResultsetRowResponsePacket>();
        int n = ++i;
        ++i;
        MysqlPacket rowPacket = mysqlPackets.get(n);
        while (!EOFPacket.isEOFPacket(rowPacket)) {
            this.textResultsetRowResponsePacketList.add(TextResultsetRowResponsePacket.parse(rowPacket));
            rowPacket = mysqlPackets.get(i++);
        }
        this.rowsSize = this.textResultsetRowResponsePacketList.size();
    }

    @Override
    public int getRowsSize() {
        return this.rowsSize;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        Integer columnIndex = this.columnIndexMap.get(columnLabel);
        if (columnIndex != null) {
            return columnIndex;
        }
        this.executionMonitor.onError(-5);
        String errorMessage = "Get column value failed: `column is not exist in query result`. Column name: `" + columnLabel + "`. Current row: " + this.getRow() + "`. Connection info: `" + this.connectionInfo + "`.";
        LOG.error(errorMessage);
        throw new SQLException(errorMessage);
    }

    private <R> R getColumnValue(int columnIndex, Function<byte[], R> converter) throws SQLException {
        int currentRow = this.getRow();
        if (currentRow >= 1 && currentRow <= this.rowsSize) {
            TextResultsetRowResponsePacket rowResponsePacket = this.textResultsetRowResponsePacketList.get(currentRow - 1);
            List<byte[]> columnValues = rowResponsePacket.getColumnsValues();
            if (columnIndex > 0 && columnIndex <= columnValues.size()) {
                byte[] columnValue = columnValues.get(columnIndex - 1);
                this.wasNull = columnValue == null;
                try {
                    return converter.apply(columnValue);
                }
                catch (Exception e) {
                    this.executionMonitor.onError(-5);
                    ColumnDefinition41ResponsePacket columnDefinition41ResponsePacket = null;
                    if (columnIndex <= this.columnDefinition41ResponsePacketList.size()) {
                        columnDefinition41ResponsePacket = this.columnDefinition41ResponsePacketList.get(columnIndex - 1);
                    }
                    String errorMessage = "Get column value failed: `convert value error`. Column index: `" + columnIndex + "`. Current row: `" + currentRow + "`. Column value: `" + Arrays.toString(columnValue) + "`. Column definition: `" + columnDefinition41ResponsePacket + "`. Connection info: `" + this.connectionInfo + "`.";
                    LOG.error(errorMessage, (Throwable)e);
                    throw new SQLException(errorMessage, e);
                }
            }
            this.executionMonitor.onError(-5);
            String errorMessage = "Get column value failed: `columnIndex out of range`. Invalid column index: `" + columnIndex + "`. Columns size: `" + columnValues.size() + "`. Current row: `" + currentRow + "`. Rows size: `" + this.rowsSize + "`. Connection info: `" + this.connectionInfo + "`.";
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
        this.executionMonitor.onError(-5);
        String errorMessage = "Get column value failed: `invalid row`. Current row: `" + currentRow + "`. Rows size: `" + this.rowsSize + "`. Connection info: `" + this.connectionInfo + "`.";
        LOG.error(errorMessage);
        throw new SQLException(errorMessage);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getColumnValue(columnIndex, bytesValue -> {
            if (bytesValue != null) {
                return new String((byte[])bytesValue, this.connectionInfo.getJavaCharset());
            }
            return null;
        });
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (value != null) {
            if (value.contains("0")) {
                return false;
            }
            if (value.contains("1")) {
                return true;
            }
            this.executionMonitor.onError(-5);
            String errorMessage = "Get column boolean value failed: `invalid value, value must contain a '0'(false) or contain a '1'(true)`. Column index: `" + columnIndex + "`. Current row: `" + this.getRow() + "`. Invalid column value: `" + value + "`. Connection info: `" + this.connectionInfo + "`.";
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
        return false;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getColumnValue(columnIndex, bytesValue -> {
            if (bytesValue != null && ((byte[])bytesValue).length > 0) {
                return bytesValue[0];
            }
            return (byte)0;
        });
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    private <T extends Number> T parseNumber(int columnIndex, Function<String, T> numberParser, T nullValue, boolean includeFraction) throws SQLException {
        String value = this.getString(columnIndex);
        if (value != null) {
            try {
                int pointIndex = value.indexOf(46);
                if (!includeFraction && pointIndex != -1) {
                    return (T)((Number)numberParser.apply(value.substring(0, pointIndex)));
                }
                return (T)((Number)numberParser.apply(value));
            }
            catch (Exception e) {
                this.executionMonitor.onError(-5);
                String errorMessage = "Get column number value failed: `parse number error`. Column index: `" + columnIndex + "`. Current row: `" + this.getRow() + "`. Invalid column value: `" + value + "`. Connection info: `" + this.connectionInfo + "`.";
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        }
        return nullValue;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.parseNumber(columnIndex, Short::parseShort, (short)0, false);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.parseNumber(columnIndex, Integer::parseInt, 0, false);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.parseNumber(columnIndex, Long::parseLong, 0L, false);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.parseNumber(columnIndex, Float::parseFloat, Float.valueOf(0.0f), true).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.parseNumber(columnIndex, Double::parseDouble, 0.0, true);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.parseNumber(columnIndex, BigDecimal::new, null, true);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.parseNumber(columnIndex, value -> new BigDecimal((String)value).setScale(scale, 3), null, true);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getColumnValue(columnIndex, bytesValue -> bytesValue);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, Calendar.getInstance());
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        String value = this.getString(columnIndex);
        if (value != null) {
            try {
                if (cal == null) {
                    cal = Calendar.getInstance();
                }
                int year = Integer.parseInt(value.substring(0, 4));
                int month = 1;
                int day = 1;
                if (value.length() > 5) {
                    month = Integer.parseInt(value.substring(5, 7));
                    day = Integer.parseInt(value.substring(8, 10));
                }
                cal.set(year, month - 1, day);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return new Date(cal.getTimeInMillis());
            }
            catch (Exception e) {
                this.executionMonitor.onError(-5);
                String errorMessage = "Get column date value failed: `parse date error`. Column index: `" + columnIndex + "`. Current row: `" + this.getRow() + "`. Invalid column value: `" + value + "`. Connection info: `" + this.connectionInfo + "`.";
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        }
        return null;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, Calendar.getInstance());
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        String value = this.getString(columnIndex);
        if (value != null) {
            try {
                if (cal == null) {
                    cal = Calendar.getInstance();
                }
                String[] timeParts = value.split(":");
                int hour = Integer.parseInt(timeParts[0]);
                int minute = Integer.parseInt(timeParts[1]);
                String[] secondsParts = timeParts[2].split("\\.");
                int second = Integer.parseInt(secondsParts[0]);
                int millisecond = 0;
                if (secondsParts.length > 1) {
                    if (secondsParts[1].length() > 3) {
                        secondsParts[1] = secondsParts[1].substring(0, 3);
                    }
                    millisecond = Integer.parseInt(secondsParts[1]);
                }
                cal.set(1970, 0, 1);
                cal.set(11, hour);
                cal.set(12, minute);
                cal.set(13, second);
                cal.set(14, millisecond);
                return new Time(cal.getTimeInMillis());
            }
            catch (Exception e) {
                this.executionMonitor.onError(-5);
                String errorMessage = "Get column time value failed: `parse time error`. Column index: `" + columnIndex + "`. Current row: `" + this.getRow() + "`. Invalid column value: `" + value + "`. Connection info: `" + this.connectionInfo + "`.";
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        }
        return null;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        String value = this.getString(columnIndex);
        if (value != null) {
            try {
                if (cal == null) {
                    cal = Calendar.getInstance();
                }
                int year = Integer.parseInt(value.substring(0, 4));
                int month = 1;
                int day = 1;
                if (value.length() > 5) {
                    month = Integer.parseInt(value.substring(5, 7));
                    day = Integer.parseInt(value.substring(8, 10));
                }
                int hour = 0;
                int minute = 0;
                int second = 0;
                int millisecond = 0;
                if (value.length() > 10) {
                    hour = Integer.parseInt(value.substring(11, 13));
                    minute = Integer.parseInt(value.substring(14, 16));
                    second = Integer.parseInt(value.substring(17, 19));
                }
                if (value.length() > 19) {
                    millisecond = Integer.parseInt(value.substring(20, 23));
                }
                cal.set(year, month - 1, day);
                cal.set(11, hour);
                cal.set(12, minute);
                cal.set(13, second);
                cal.set(14, millisecond);
                return new Timestamp(cal.getTimeInMillis());
            }
            catch (Exception e) {
                this.executionMonitor.onError(-5);
                String errorMessage = "Get column timestamp value failed: `parse timestamp error`. Column index: `" + columnIndex + "`. Current row: `" + this.getRow() + "`. Invalid column value: `" + value + "`. Connection info: `" + this.connectionInfo + "`.";
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getColumnValue(columnIndex, bytesValue -> {
            if (bytesValue != null) {
                return new ByteArrayInputStream((byte[])bytesValue);
            }
            return null;
        });
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (value != null) {
            return new StringReader(value);
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (value != null) {
            try {
                return new URL(value);
            }
            catch (Exception e) {
                this.executionMonitor.onError(-5);
                String errorMessage = "Get column URL value failed: `parse URL error`. Column index: `" + columnIndex + "`. Current row: `" + this.getRow() + "`. Invalid column value: `" + value + "`. Connection info: `" + this.connectionInfo + "`.";
                LOG.error(errorMessage, (Throwable)e);
                throw new SQLException(errorMessage, e);
            }
        }
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.columnDefinition41ResponsePacketList.size()) {
            ColumnDefinition41ResponsePacket columnDefinition41ResponsePacket = this.columnDefinition41ResponsePacketList.get(columnIndex - 1);
            Class<?> javaType = ColumnTypeMappingUtil.getJavaType(columnDefinition41ResponsePacket.getColumnType(), columnDefinition41ResponsePacket.getColumnDefinitionFlags());
            return this.getObject(columnIndex, javaType);
        }
        this.executionMonitor.onError(-5);
        String errorMessage = "Get column object value failed: `columnIndex out of range`. Invalid column index: `" + columnIndex + "`. Columns size: `" + this.columnDefinition41ResponsePacketList.size() + "`. Current row: `" + this.getRow() + "`. Rows size: `" + this.rowsSize + "`. Connection info: `" + this.connectionInfo + "`.";
        LOG.error(errorMessage);
        throw new SQLException(errorMessage);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        Object columnValue;
        if (type == null) {
            this.executionMonitor.onError(-5);
            String errorMessage = "Get column object value failed: `type could not be null`. Column index: `" + columnIndex + "`. type: `null`. Current row: `" + this.getRow() + "`. Connection info: `" + this.connectionInfo + "`.";
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
        if (String.class == type) {
            columnValue = this.getString(columnIndex);
        } else if (Integer.class == type || Integer.TYPE == type) {
            columnValue = this.getInt(columnIndex);
        } else if (Long.class == type || Long.TYPE == type) {
            columnValue = this.getLong(columnIndex);
        } else if (Boolean.class == type || Boolean.TYPE == type) {
            columnValue = this.getBoolean(columnIndex);
        } else if (Double.class == type || Double.TYPE == type) {
            columnValue = this.getDouble(columnIndex);
        } else if (Float.class == type || Float.TYPE == type) {
            columnValue = Float.valueOf(this.getFloat(columnIndex));
        } else if (Short.class == type || Short.TYPE == type) {
            columnValue = this.getShort(columnIndex);
        } else if (BigDecimal.class == type) {
            columnValue = this.getBigDecimal(columnIndex);
        } else if (Date.class == type) {
            columnValue = this.getDate(columnIndex);
        } else if (Time.class == type) {
            columnValue = this.getTime(columnIndex);
        } else if (Timestamp.class == type || java.util.Date.class == type) {
            columnValue = this.getTimestamp(columnIndex);
        } else if (byte[].class == type) {
            columnValue = this.getBytes(columnIndex);
        } else if (URL.class == type) {
            columnValue = this.getURL(columnIndex);
        } else if (Byte.class == type || Byte.TYPE == type) {
            columnValue = this.getByte(columnIndex);
        } else {
            this.executionMonitor.onError(-5);
            String errorMessage = "Get column object value failed: `unsupported java type`. Column index: `" + columnIndex + "`. type: `" + type + "`. Current row: `" + this.getRow() + "`. Connection info: `" + this.connectionInfo + "`.";
            LOG.error(errorMessage);
            throw new SQLException(errorMessage);
        }
        if (!this.wasNull()) {
            return (T)columnValue;
        }
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.columnDefinition41ResponsePacketList.size()) {
            ColumnDefinition41ResponsePacket definition4Packet = this.columnDefinition41ResponsePacketList.get(columnIndex - 1);
            String columnTypeName = ColumnTypeMappingUtil.getTypeName(definition4Packet.getColumnType(), definition4Packet.getColumnDefinitionFlags(), definition4Packet.getMaximumColumnLength());
            Class<?> javaType = map.get(columnTypeName);
            if (javaType == null) {
                javaType = ColumnTypeMappingUtil.getJavaType(definition4Packet.getColumnType(), definition4Packet.getColumnDefinitionFlags());
            }
            return this.getObject(columnIndex, javaType);
        }
        this.executionMonitor.onError(-5);
        String errorMessage = "Get column object value failed: `columnIndex out of range`. Invalid column index: `" + columnIndex + "`. Columns size: `" + this.columnDefinition41ResponsePacketList.size() + "`. Current row: `" + this.getRow() + "`. Rows size: `" + this.rowsSize + "`. javaClassMap: `" + map + "`. Connection info: `" + this.connectionInfo + "`.";
        LOG.error(errorMessage);
        throw new SQLException(errorMessage);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new TextResultSetMetaData(this.columnDefinition41ResponsePacketList);
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return ReadonlyTextResultSet.class == iface;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getCursorName()");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getSQLXML(int columnIndex)");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getSQLXML(String columnLabel)");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getRowId(int columnIndex)");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getRowId(String columnLabel)");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getRef(int columnIndex)");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getRef(String columnLabel)");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getBlob(int columnIndex)");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getBlob(String columnLabel)");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getClob(int columnIndex)");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getClob(String columnLabel)");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getNClob(int columnIndex)");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getNClob(String columnLabel)");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getArray(int columnIndex)");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getArray(String columnLabel)");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw SQLFeatureNotSupportedExceptionBuilder.build("ReadonlyTextResultSet#getHoldability()");
    }
}

