/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.result;

import com.heimuheimu.mysql.jdbc.packet.CharsetMappingUtil;
import com.heimuheimu.mysql.jdbc.packet.ColumnDefinitionFlagsUtil;
import com.heimuheimu.mysql.jdbc.packet.ColumnTypeMappingUtil;
import com.heimuheimu.mysql.jdbc.packet.command.text.ColumnDefinition41ResponsePacket;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextResultSetMetaData
implements ResultSetMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(TextResultSetMetaData.class);
    private final List<ColumnDefinition41ResponsePacket> columnDefinition41ResponsePacketList;

    public TextResultSetMetaData(List<ColumnDefinition41ResponsePacket> columnDefinition41ResponsePacketList) {
        this.columnDefinition41ResponsePacketList = columnDefinition41ResponsePacketList;
    }

    @Override
    public int getColumnCount() {
        return this.columnDefinition41ResponsePacketList.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        return ColumnDefinitionFlagsUtil.isColumnDefinitionEnabled(columnDefinitionPacket.getColumnDefinitionFlags(), 9);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        Class<?> javaType = this.getJavaType(column);
        if (javaType == String.class) {
            ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
            return CharsetMappingUtil.isCaseSensitive(columnDefinitionPacket.getColumnCharacterId());
        }
        return false;
    }

    @Override
    public boolean isSearchable(int column) {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.getJavaType(column) == BigDecimal.class;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        if (ColumnDefinitionFlagsUtil.isColumnDefinitionEnabled(columnDefinitionPacket.getColumnDefinitionFlags(), 0)) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        return !ColumnDefinitionFlagsUtil.isColumnDefinitionEnabled(columnDefinitionPacket.getColumnDefinitionFlags(), 5);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        if (columnDefinitionPacket.getMaximumColumnLength() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)columnDefinitionPacket.getMaximumColumnLength();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        return columnDefinitionPacket.getColumnName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        return columnDefinitionPacket.getOriginalColumnName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        return columnDefinitionPacket.getDatabaseName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        int maximumColumnLength = columnDefinitionPacket.getMaximumColumnLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)columnDefinitionPacket.getMaximumColumnLength();
        Class<?> columnJavaType = this.getJavaType(column);
        if (columnJavaType == Float.class || columnJavaType == Double.class || columnJavaType == BigDecimal.class) {
            boolean isUnsigned = ColumnDefinitionFlagsUtil.isColumnDefinitionEnabled(columnDefinitionPacket.getColumnDefinitionFlags(), 5);
            int adjustLength = 0;
            if (columnDefinitionPacket.getDecimals() > 0) {
                if (columnJavaType == BigDecimal.class) {
                    adjustLength = isUnsigned ? -1 : -2;
                }
            } else {
                adjustLength = columnJavaType == BigDecimal.class ? (isUnsigned ? 0 : -1) : 1;
            }
            return maximumColumnLength + adjustLength;
        }
        if (columnJavaType == String.class) {
            return maximumColumnLength / CharsetMappingUtil.getMaxBytesPerChar(columnDefinitionPacket.getColumnCharacterId());
        }
        return maximumColumnLength;
    }

    @Override
    public int getScale(int column) throws SQLException {
        Class<?> javaType = this.getJavaType(column);
        if (Number.class.isAssignableFrom(javaType)) {
            ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
            return columnDefinitionPacket.getDecimals();
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        return columnDefinitionPacket.getTableName();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        return columnDefinitionPacket.getCatalog();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        return ColumnTypeMappingUtil.getJDBCType(columnDefinitionPacket.getColumnType(), columnDefinitionPacket.getColumnDefinitionFlags(), columnDefinitionPacket.getMaximumColumnLength());
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(column);
        return ColumnTypeMappingUtil.getTypeName(columnDefinitionPacket.getColumnType(), columnDefinitionPacket.getColumnDefinitionFlags(), columnDefinitionPacket.getMaximumColumnLength());
    }

    @Override
    public boolean isReadOnly(int column) {
        return true;
    }

    @Override
    public boolean isWritable(int column) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getJavaType(column).getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return TextResultSetMetaData.class == iface;
    }

    private ColumnDefinition41ResponsePacket getColumnDefinition41ResponsePacket(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.columnDefinition41ResponsePacketList.size()) {
            return this.columnDefinition41ResponsePacketList.get(columnIndex - 1);
        }
        String errorMessage = "Get column definition packet failed: `columnIndex out of range`. Invalid column index: `" + columnIndex + "`. Columns size: `" + this.columnDefinition41ResponsePacketList.size() + "`.";
        LOG.error(errorMessage);
        throw new SQLException(errorMessage);
    }

    private Class<?> getJavaType(int columnIndex) throws SQLException {
        ColumnDefinition41ResponsePacket columnDefinitionPacket = this.getColumnDefinition41ResponsePacket(columnIndex);
        return ColumnTypeMappingUtil.getJavaType(columnDefinitionPacket.getColumnType(), columnDefinitionPacket.getColumnDefinitionFlags());
    }
}

