/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.util;

import java.util.Arrays;

public class BytesUtil {
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final long[] MAXIMUM_INTEGER_VALUE_ARRAY = new long[8];

    private BytesUtil() {
    }

    public static long decodeUnsignedInteger(byte[] src, int offset, int length) throws NullPointerException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (src == null) {
            throw new NullPointerException("Convert bytes to unsigned integer failed: `src could not be null`. `src`:`null`. `offset`:`" + offset + "`. `length`:`" + length + "`.");
        }
        if (offset < 0 || offset >= src.length) {
            throw new IllegalArgumentException("Convert bytes to unsigned integer failed: `invalid offset`. `src`:`" + Arrays.toString(src) + "`. `offset`:`" + offset + "`. `length`:`" + length + "`.");
        }
        if (length < 1 || length > 8) {
            throw new IllegalArgumentException("Convert bytes to unsigned integer failed: `invalid length`. `src`:`" + Arrays.toString(src) + "`. `offset`:`" + offset + "`. `length`:`" + length + "`.");
        }
        if (offset + length > src.length) {
            throw new ArrayIndexOutOfBoundsException("Convert bytes to unsigned integer failed: `index is greater than or equal to the size of the array`. `src`:`" + Arrays.toString(src) + "`. `offset`:`" + offset + "`. `length`:`" + length + "`.");
        }
        if (length == 8 && src[offset + 7] < 0) {
            throw new IllegalArgumentException("Convert bytes to unsigned integer failed: `the most significant byte is less than zero`. `src`:`" + Arrays.toString(src) + "`. `offset`:`" + offset + "`. `length`:`" + length + "`.");
        }
        long value = 0L;
        for (int i = 0; i < length; ++i) {
            value |= ((long)src[offset + i] & 0xFFL) << i * 8;
        }
        return value;
    }

    public static void encodeUnsignedInteger(byte[] target, int offset, int length, long value) throws NullPointerException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (target == null) {
            throw new NullPointerException("Convert unsigned integer to bytes failed: `target could not be null`. `target`:`null`. `offset`:`" + offset + "`. `length`:`" + length + "`. `value`:`" + value + "`.");
        }
        if (offset < 0 || offset >= target.length) {
            throw new IllegalArgumentException("Convert unsigned integer to bytes failed: `invalid offset`. `target`:`" + Arrays.toString(target) + "`. `offset`:`" + offset + "`. `length`:`" + length + "`. `value`:`" + value + "`.");
        }
        if (length < 1 || length > 8) {
            throw new IllegalArgumentException("Convert unsigned integer to bytes failed: `invalid length`. `target`:`" + Arrays.toString(target) + "`. `offset`:`" + offset + "`. `length`:`" + length + "`. `value`:`" + value + "`.");
        }
        if (offset + length > target.length) {
            throw new ArrayIndexOutOfBoundsException("Convert unsigned integer to bytes failed: `index is greater than or equal to the size of the array`. `target`:`" + Arrays.toString(target) + "`. `offset`:`" + offset + "`. `length`:`" + length + "`. `value`:`" + value + "`.");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("Convert unsigned integer to bytes failed: `negative value`. `target`:`" + Arrays.toString(target) + "`. `offset`:`" + offset + "`. `length`:`" + length + "`. `value`:`" + value + "`.");
        }
        if (value > MAXIMUM_INTEGER_VALUE_ARRAY[length - 1]) {
            throw new IllegalArgumentException("Convert unsigned integer to bytes failed: `value is too large`. `target`:`" + Arrays.toString(target) + "`. `offset`:`" + offset + "`. `length`:`" + length + "`. `value`:`" + value + "`. `validMaximumValue`:`" + MAXIMUM_INTEGER_VALUE_ARRAY[length - 1] + "`.");
        }
        for (int i = 0; i < length; ++i) {
            target[offset + i] = (byte)(value >>> i * 8);
        }
    }

    public static String toHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int unsignedByteValue = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[unsignedByteValue >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[unsignedByteValue & 0xF];
        }
        return new String(hexChars);
    }

    static {
        for (int i = 0; i < 8; ++i) {
            BytesUtil.MAXIMUM_INTEGER_VALUE_ARRAY[i] = (long)(Math.pow(2.0, (i + 1) * 8) - 1.0);
        }
    }
}

