/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.util;

import com.heimuheimu.mysql.jdbc.ConnectionConfiguration;
import com.heimuheimu.mysql.jdbc.MysqlConnection;
import com.heimuheimu.mysql.jdbc.facility.UnusableServiceNotifier;
import com.heimuheimu.mysql.jdbc.net.BuildSocketException;
import com.heimuheimu.mysql.jdbc.net.SocketConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlConnectionBuildUtil {
    public static final String PROPERTY_HOST = "host";
    public static final String PROPERTY_DATABASE_NAME = "databaseName";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_CAPABILITIES_FLAGS = "capabilitiesFlags";
    public static final String PROPERTY_CHARACTER_ID = "characterId";
    public static final String PROPERTY_PING_PERIOD = "pingPeriod";
    public static final String PROPERTY_SOCKET_CONFIGURATION = "socketConfiguration";
    public static final String PROPERTY_TIMEOUT = "timeout";
    public static final String PROPERTY_SLOW_EXECUTION_THRESHOLD = "slowExecutionThreshold";
    public static final String PROPERTY_UNUSABLE_SERVICE_NOTIFIER = "unusableServiceNotifier";
    private static final Logger LOG = LoggerFactory.getLogger(MysqlConnectionBuildUtil.class);

    private MysqlConnectionBuildUtil() {
    }

    public static MysqlConnection build(String url, Map<Object, Object> connectionInfo) throws MalformedURLException, IllegalArgumentException, BuildSocketException {
        try {
            HashMap<Object, Object> allConnectionInfo = new HashMap<Object, Object>();
            allConnectionInfo.putAll(MysqlConnectionBuildUtil.parseURL(url));
            allConnectionInfo.putAll(connectionInfo);
            ConnectionConfiguration configuration = MysqlConnectionBuildUtil.getConnectionConfiguration(allConnectionInfo);
            int timeout = 5000;
            if (allConnectionInfo.containsKey(PROPERTY_TIMEOUT)) {
                timeout = (Integer)allConnectionInfo.get(PROPERTY_TIMEOUT);
            }
            int slowExecutionThreshold = 500;
            if (allConnectionInfo.containsKey(PROPERTY_SLOW_EXECUTION_THRESHOLD)) {
                slowExecutionThreshold = (Integer)allConnectionInfo.get(PROPERTY_SLOW_EXECUTION_THRESHOLD);
            }
            UnusableServiceNotifier notifier = null;
            if (allConnectionInfo.containsKey(PROPERTY_UNUSABLE_SERVICE_NOTIFIER)) {
                notifier = (UnusableServiceNotifier)allConnectionInfo.get(PROPERTY_UNUSABLE_SERVICE_NOTIFIER);
            }
            return new MysqlConnection(configuration, timeout, slowExecutionThreshold, notifier);
        }
        catch (Exception e) {
            LOG.error("Build MysqlConnection failed. url: `" + url + "`. connectionInfo: `" + connectionInfo + "`.", (Throwable)e);
            throw e;
        }
    }

    public static boolean acceptsURL(String url) {
        if (url != null) {
            return url.startsWith("jdbc:mysql://");
        }
        return false;
    }

    public static ConnectionConfiguration getConnectionConfiguration(Map<Object, Object> connectionInfo) {
        String host = (String)connectionInfo.get(PROPERTY_HOST);
        String databaseName = "";
        if (connectionInfo.containsKey(PROPERTY_DATABASE_NAME)) {
            databaseName = (String)connectionInfo.get(PROPERTY_DATABASE_NAME);
        }
        String username = (String)connectionInfo.get(PROPERTY_USER);
        String password = "";
        if (connectionInfo.containsKey(PROPERTY_PASSWORD)) {
            password = (String)connectionInfo.get(PROPERTY_PASSWORD);
        }
        int characterId = 45;
        if (connectionInfo.containsKey(PROPERTY_CHARACTER_ID)) {
            characterId = (Integer)connectionInfo.get(PROPERTY_CHARACTER_ID);
        }
        long capabilitiesFlags = 0L;
        if (connectionInfo.containsKey(PROPERTY_CAPABILITIES_FLAGS)) {
            capabilitiesFlags = (Long)connectionInfo.get(PROPERTY_CAPABILITIES_FLAGS);
        }
        int pingPeriod = 30;
        if (connectionInfo.containsKey(PROPERTY_PING_PERIOD)) {
            pingPeriod = (Integer)connectionInfo.get(PROPERTY_PING_PERIOD);
        }
        SocketConfiguration socketConfiguration = null;
        if (connectionInfo.containsKey(PROPERTY_SOCKET_CONFIGURATION)) {
            socketConfiguration = (SocketConfiguration)connectionInfo.get(PROPERTY_SOCKET_CONFIGURATION);
        }
        return new ConnectionConfiguration(host, databaseName, username, password, characterId, capabilitiesFlags, pingPeriod, socketConfiguration);
    }

    public static Map<String, Object> parseURL(String url) throws MalformedURLException {
        HashMap<String, Object> urlConnectionInfo = new HashMap<String, Object>();
        if (url != null && !(url = url.trim()).isEmpty()) {
            String originalUrl = url;
            String protocolName = "";
            String hostName = "";
            String databaseName = "";
            String queryString = "";
            int port = 3306;
            int protocolSplitCharIndex = url.indexOf("//");
            if (protocolSplitCharIndex >= 0) {
                int portSplitCharIndex;
                int databaseNameSplitCharIndex;
                protocolName = url.substring(0, protocolSplitCharIndex);
                int querySplitCharIndex = (url = url.substring(protocolSplitCharIndex + 2)).indexOf("?");
                if (querySplitCharIndex >= 0) {
                    queryString = url.substring(querySplitCharIndex + 1);
                    url = url.substring(0, querySplitCharIndex);
                }
                if ((databaseNameSplitCharIndex = url.indexOf("/")) >= 0) {
                    databaseName = url.substring(databaseNameSplitCharIndex + 1);
                    url = url.substring(0, databaseNameSplitCharIndex);
                }
                if ((portSplitCharIndex = url.indexOf(":")) >= 0) {
                    try {
                        port = Integer.parseInt(url.substring(portSplitCharIndex + 1));
                    }
                    catch (Exception e) {
                        throw new MalformedURLException("Parse mysql jdbc url failed: `invalid port,must be number`. url: `" + originalUrl + "`.");
                    }
                    url = url.substring(0, portSplitCharIndex);
                }
                hostName = url;
            }
            if (!protocolName.equals("jdbc:mysql:")) {
                throw new MalformedURLException("Parse mysql jdbc url failed: `invalid protocol, must start with 'jdbc:mysql://'`. url: `" + originalUrl + "`.");
            }
            if (hostName.isEmpty()) {
                throw new MalformedURLException("Parse mysql jdbc url failed: `empty host`. url: `" + originalUrl + "`.");
            }
            urlConnectionInfo.put(PROPERTY_HOST, hostName + ":" + port);
            urlConnectionInfo.put(PROPERTY_DATABASE_NAME, databaseName);
            try {
                urlConnectionInfo.putAll(MysqlConnectionBuildUtil.parseQueryString(queryString));
            }
            catch (Exception e) {
                throw new MalformedURLException("Parse mysql jdbc url failed: `" + e.getMessage() + "`. url: `" + originalUrl + "`.");
            }
        }
        return urlConnectionInfo;
    }

    private static Map<String, Object> parseQueryString(String queryString) throws MalformedURLException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (queryString != null && !queryString.isEmpty()) {
            String[] parameterPairs;
            block30: for (String parameterPair : parameterPairs = queryString.split("&")) {
                String[] parameterParts = parameterPair.split("=");
                if (parameterParts.length != 2) continue;
                String parameterName = parameterParts[0];
                String parameterValue = parameterParts[1];
                if (parameterValue != null && !parameterValue.isEmpty()) {
                    try {
                        parameterValue = URLDecoder.decode(parameterValue, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                switch (parameterName) {
                    case "user": {
                        params.put(PROPERTY_USER, parameterValue);
                        continue block30;
                    }
                    case "password": {
                        params.put(PROPERTY_PASSWORD, parameterValue);
                        continue block30;
                    }
                    case "characterId": {
                        try {
                            params.put(PROPERTY_CHARACTER_ID, Integer.parseInt(parameterValue));
                            continue block30;
                        }
                        catch (Exception e) {
                            throw new MalformedURLException("invalid characterId");
                        }
                    }
                    case "capabilitiesFlags": {
                        try {
                            params.put(PROPERTY_CAPABILITIES_FLAGS, Long.parseLong(parameterValue));
                            continue block30;
                        }
                        catch (Exception e) {
                            throw new MalformedURLException("invalid capabilitiesFlags");
                        }
                    }
                    case "pingPeriod": {
                        try {
                            params.put(PROPERTY_PING_PERIOD, Integer.parseInt(parameterValue));
                            continue block30;
                        }
                        catch (Exception e) {
                            throw new MalformedURLException("invalid pingPeriod");
                        }
                    }
                    case "timeout": {
                        try {
                            params.put(PROPERTY_TIMEOUT, Integer.parseInt(parameterValue));
                            continue block30;
                        }
                        catch (Exception e) {
                            throw new MalformedURLException("invalid timeout");
                        }
                    }
                    case "slowExecutionThreshold": {
                        try {
                            params.put(PROPERTY_SLOW_EXECUTION_THRESHOLD, Integer.parseInt(parameterValue));
                            continue block30;
                        }
                        catch (Exception e) {
                            throw new MalformedURLException("invalid slowExecutionThreshold");
                        }
                    }
                }
            }
        }
        return params;
    }
}

