/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.mysql.jdbc.util;

import java.util.Arrays;

public class StringUtil {
    private StringUtil() {
    }

    public static String escape(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int specialCharacterCount = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\r': 
                case '\u001a': 
                case '\'': 
                case '\\': {
                    ++specialCharacterCount;
                }
            }
        }
        if (specialCharacterCount > 0) {
            StringBuilder buffer = new StringBuilder(value.length() + specialCharacterCount);
            block14: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\u0000': {
                        buffer.append('\\');
                        buffer.append('0');
                        continue block14;
                    }
                    case '\'': {
                        buffer.append('\\');
                        buffer.append('\'');
                        continue block14;
                    }
                    case '\b': {
                        buffer.append('\\');
                        buffer.append('b');
                        continue block14;
                    }
                    case '\n': {
                        buffer.append('\\');
                        buffer.append('n');
                        continue block14;
                    }
                    case '\r': {
                        buffer.append('\\');
                        buffer.append('r');
                        continue block14;
                    }
                    case '\t': {
                        buffer.append('\\');
                        buffer.append('t');
                        continue block14;
                    }
                    case '\u001a': {
                        buffer.append('\\');
                        buffer.append('Z');
                        continue block14;
                    }
                    case '\\': {
                        buffer.append('\\');
                        buffer.append('\\');
                        continue block14;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
            return buffer.toString();
        }
        return value;
    }

    public static String hidePassword(String password) {
        if (password == null || password.isEmpty()) {
            return password;
        }
        char[] chars = password.toCharArray();
        int passwordLength = chars.length;
        if (passwordLength <= 2) {
            Arrays.fill(chars, '*');
        } else if (passwordLength < 8) {
            Arrays.fill(chars, 1, passwordLength - 1, '*');
        } else {
            Arrays.fill(chars, 2, passwordLength - 2, '*');
        }
        return new String(chars);
    }
}

