/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.alarm;

import com.heimuheimu.naivemonitor.alarm.ServiceAlarmMessage;
import com.heimuheimu.naivemonitor.alarm.ServiceAlarmMessageNotifier;
import com.heimuheimu.naivemonitor.alarm.ServiceContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaiveServiceAlarm {
    private static final Logger LOGGER = LoggerFactory.getLogger(NaiveServiceAlarm.class);
    private final List<ServiceAlarmMessageNotifier> notifierList;
    private final int maxMessageBatchSize;
    private final int mergeMessageIntervalSeconds;
    private final Object notificationThreadLock = new Object();
    private final LinkedBlockingQueue<ServiceContextMessage> messageQueue = new LinkedBlockingQueue();
    private boolean isNotificationThreadRunning = false;

    public NaiveServiceAlarm(List<ServiceAlarmMessageNotifier> notifierList) throws IllegalArgumentException {
        this(notifierList, 50, 3);
    }

    public NaiveServiceAlarm(List<ServiceAlarmMessageNotifier> notifierList, int maxMessageBatchSize, int mergeMessageIntervalSeconds) {
        if (notifierList == null || notifierList.isEmpty()) {
            LOGGER.error("Created NaiveServiceAlarm failed: `notifier list could not be null or empty`.");
            throw new IllegalArgumentException("Created NaiveServiceAlarm failed: `notifier list could not be null or empty`.");
        }
        this.maxMessageBatchSize = maxMessageBatchSize;
        this.mergeMessageIntervalSeconds = mergeMessageIntervalSeconds;
        this.notifierList = notifierList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCrashed(ServiceContext serviceContext) {
        Object object = this.notificationThreadLock;
        synchronized (object) {
            this.messageQueue.add(new ServiceContextMessage(serviceContext, -1));
            this.startNotificationThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRecovered(ServiceContext serviceContext) {
        Object object = this.notificationThreadLock;
        synchronized (object) {
            this.messageQueue.add(new ServiceContextMessage(serviceContext, 0));
            this.startNotificationThread();
        }
    }

    private void startNotificationThread() {
        if (!this.isNotificationThreadRunning) {
            this.isNotificationThreadRunning = true;
            NotificationThread notificationThread = new NotificationThread();
            notificationThread.setName("naivemonitor-alarm-message-notification");
            notificationThread.setDaemon(true);
            notificationThread.start();
        }
    }

    private void send(ServiceAlarmMessage serviceAlarmMessage) {
        boolean isSentSuccess = false;
        ServiceAlarmMessageNotifier sentNotifier = null;
        for (ServiceAlarmMessageNotifier notifier : this.notifierList) {
            try {
                isSentSuccess = notifier.send(serviceAlarmMessage);
                if (!isSentSuccess) continue;
                sentNotifier = notifier;
                break;
            }
            catch (Exception e) {
                LOGGER.error("Send ServiceAlarmMessage failed: `encounter unexpected error`. ServiceAlarmMessage: `" + serviceAlarmMessage + "`. Notifier: `" + notifier + "`.", (Throwable)e);
            }
        }
        if (isSentSuccess) {
            LOGGER.info("Send ServiceAlarmMessage success. ServiceAlarmMessage: `" + serviceAlarmMessage + "`. Notifier: `" + sentNotifier + "`.");
        } else {
            LOGGER.error("Send ServiceAlarmMessage completely failed. ServiceAlarmMessage:`" + serviceAlarmMessage + "`. Notifiers: " + this.notifierList + "`.");
        }
    }

    private class NotificationThread
    extends Thread {
        private NotificationThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.debug("NotificationThread has benn started.");
            boolean stopFlag = false;
            while (!stopFlag) {
                try {
                    HashMap<String, ServiceAlarmMessage> alarmMessageMap = new HashMap<String, ServiceAlarmMessage>();
                    int mergedSize = 0;
                    ServiceContextMessage message = (ServiceContextMessage)NaiveServiceAlarm.this.messageQueue.poll();
                    if (message != null) {
                        this.addToAlarmMessageMap(alarmMessageMap, message);
                        ++mergedSize;
                        while (mergedSize < NaiveServiceAlarm.this.maxMessageBatchSize && (message = (ServiceContextMessage)NaiveServiceAlarm.this.messageQueue.poll(NaiveServiceAlarm.this.mergeMessageIntervalSeconds, TimeUnit.SECONDS)) != null) {
                            this.addToAlarmMessageMap(alarmMessageMap, message);
                            ++mergedSize;
                        }
                    }
                    if (!alarmMessageMap.isEmpty()) {
                        for (ServiceAlarmMessage serviceAlarmMessage : alarmMessageMap.values()) {
                            NaiveServiceAlarm.this.send(serviceAlarmMessage);
                        }
                        continue;
                    }
                    Object object = NaiveServiceAlarm.this.notificationThreadLock;
                    synchronized (object) {
                        if (NaiveServiceAlarm.this.messageQueue.isEmpty()) {
                            stopFlag = true;
                            NaiveServiceAlarm.this.isNotificationThreadRunning = false;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("NotificationThread run failed: `encounter unexpected error`. ServiceAlarmMessage maybe lost.", (Throwable)e);
                    stopFlag = true;
                    Object object = NaiveServiceAlarm.this.notificationThreadLock;
                    synchronized (object) {
                        NaiveServiceAlarm.this.isNotificationThreadRunning = false;
                    }
                }
            }
            LOGGER.debug("NotificationThread has benn stopped.");
        }

        private void addToAlarmMessageMap(Map<String, ServiceAlarmMessage> alarmMessageMap, ServiceContextMessage message) {
            ServiceContext serviceContext = message.serviceContext;
            String serviceKey = this.getServiceKey(serviceContext);
            ServiceAlarmMessage alarmMessage = alarmMessageMap.get(serviceKey);
            if (alarmMessage == null) {
                alarmMessage = new ServiceAlarmMessage(serviceContext.getName(), serviceContext.getHost(), serviceContext.getProject());
                alarmMessageMap.put(serviceKey, alarmMessage);
            }
            if (message.state == -1) {
                alarmMessage.onCrashed(serviceContext.getRemoteHost());
                LOGGER.debug("Add crashed `{}` to `{}`.", (Object)serviceContext.getRemoteHost(), (Object)alarmMessage);
            } else {
                alarmMessage.onRecovered(serviceContext.getRemoteHost());
                LOGGER.debug("Add recovered `{}` to `{}`.", (Object)serviceContext.getRemoteHost(), (Object)alarmMessage);
            }
        }

        private String getServiceKey(ServiceContext context) {
            return context.getHost() + "_" + context.getProject() + "_" + context.getName();
        }
    }

    private static class ServiceContextMessage {
        private static final int STATE_CRASHED = -1;
        private static final int STATE_RECOVERED = 0;
        private final ServiceContext serviceContext;
        private final int state;

        public ServiceContextMessage(ServiceContext serviceContext, int state) {
            this.serviceContext = serviceContext;
            this.state = state;
        }
    }
}

