/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.alarm;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServiceAlarmMessage {
    private final String name;
    private final String host;
    private final String project;
    private final Date createdTime = new Date();
    private int crashedTimes = 0;
    private int recoveredTimes = 0;
    private final Set<String> crashedRemoteHostSet = new HashSet<String>();
    private final Map<String, Integer> crashingRemoteHostMap = new HashMap<String, Integer>();

    public ServiceAlarmMessage(String name, String host, String project) {
        this.name = name;
        this.host = host;
        this.project = project;
    }

    public void onCrashed(String remoteHost) {
        ++this.crashedTimes;
        if (remoteHost != null && !remoteHost.isEmpty()) {
            this.crashedRemoteHostSet.add(remoteHost);
            this.crashingRemoteHostMap.put(remoteHost, 1);
        }
    }

    public void onRecovered(String remoteHost) {
        ++this.recoveredTimes;
        if (remoteHost != null && !remoteHost.isEmpty()) {
            this.crashingRemoteHostMap.remove(remoteHost);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public String getProject() {
        return this.project;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public int getCrashedTimes() {
        return this.crashedTimes;
    }

    public int getRecoveredTimes() {
        return this.recoveredTimes;
    }

    public Set<String> getCrashedRemoteHostSet() {
        return this.crashedRemoteHostSet;
    }

    public Set<String> getCrashingRemoteHostSet() {
        if (this.crashingRemoteHostMap.isEmpty()) {
            return new HashSet<String>();
        }
        return new HashSet<String>(this.crashingRemoteHostMap.keySet());
    }

    public String toText() {
        String title = this.getName() + " \u4e0d\u53ef\u670d\u52a1";
        StringBuilder buffer = new StringBuilder(title).append("\n");
        buffer.append("\u670d\u52a1\u540d\u79f0\uff1a ").append(this.getName()).append("\n");
        buffer.append("\u9879\u76ee\u540d\u79f0\uff1a ").append(this.getProject()).append("\n");
        buffer.append("\u4e3b\u673a\u540d\u79f0\uff1a ").append(this.getHost()).append("\n");
        buffer.append("\u4e0d\u53ef\u7528\u6b21\u6570\uff1a ").append(this.getCrashedTimes()).append("\n");
        buffer.append("\u6062\u590d\u6b21\u6570\uff1a ").append(this.getRecoveredTimes()).append("\n");
        if (this.getCrashingRemoteHostSet().isEmpty()) {
            buffer.append("\u5f53\u524d\u4e0d\u53ef\u7528\u8fdc\u7a0b\u4e3b\u673a\u5217\u8868\uff1a [ \u65e0 ] \n");
        } else {
            buffer.append("\u5f53\u524d\u4e0d\u53ef\u7528\u8fdc\u7a0b\u4e3b\u673a\u5217\u8868\uff1a \n");
            ArrayList<String> crashingRemoteHostList = new ArrayList<String>(this.getCrashingRemoteHostSet());
            Collections.sort(crashingRemoteHostList);
            for (String remoteHost : crashingRemoteHostList) {
                buffer.append("  - ").append(remoteHost).append("\n");
            }
        }
        if (!this.getCrashedRemoteHostSet().isEmpty()) {
            buffer.append("\u5386\u53f2\u4e0d\u53ef\u7528\u8fdc\u7a0b\u4e3b\u673a\u5217\u8868\uff1a \n");
            ArrayList<String> crashedRemoteHostList = new ArrayList<String>(this.getCrashedRemoteHostSet());
            Collections.sort(crashedRemoteHostList);
            for (String remoteHost : crashedRemoteHostList) {
                buffer.append("  - ").append(remoteHost).append("\n");
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        buffer.append("\u62a5\u8b66\u65f6\u95f4\uff1a ").append(dateFormat.format(this.getCreatedTime())).append("\n");
        return buffer.toString();
    }

    public String toString() {
        return "ServiceAlarmMessage{name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", project='" + this.project + '\'' + ", crashedTimes=" + this.crashedTimes + ", recoveredTimes=" + this.recoveredTimes + ", crashedRemoteHostSet=" + this.crashedRemoteHostSet + ", crashingRemoteHostMap=" + this.crashingRemoteHostMap + '}';
    }
}

