/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.alarm.support;

import com.heimuheimu.naivemonitor.alarm.ServiceAlarmMessage;
import com.heimuheimu.naivemonitor.alarm.ServiceAlarmMessageNotifier;
import com.heimuheimu.naivemonitor.http.NaiveHttpPost;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingTalkServiceAlarmMessageNotifier
implements ServiceAlarmMessageNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(DingTalkServiceAlarmMessageNotifier.class);
    private final String url;
    private final String proxyHost;
    private final int timeout;
    private final String crashingImageUrl;
    private final String recoveredImageUrl;

    public DingTalkServiceAlarmMessageNotifier(String url) {
        this(url, null, 5000, null, null);
    }

    public DingTalkServiceAlarmMessageNotifier(String url, String proxyHost) {
        this(url, proxyHost, 5000, null, null);
    }

    public DingTalkServiceAlarmMessageNotifier(String url, String proxyHost, int timeout, String crashingImageUrl, String recoveredImageUrl) {
        this.url = url;
        this.proxyHost = proxyHost;
        this.timeout = timeout;
        this.crashingImageUrl = crashingImageUrl != null ? crashingImageUrl : "";
        this.recoveredImageUrl = recoveredImageUrl != null ? recoveredImageUrl : "";
    }

    @Override
    public boolean send(ServiceAlarmMessage serviceAlarmMessage) {
        if (this.url != null && !this.url.isEmpty()) {
            long startTime = System.currentTimeMillis();
            try {
                NaiveHttpPost post = new NaiveHttpPost(this.url, this.timeout, this.proxyHost);
                post.getUrlConnection().setRequestProperty("Content-Type", "application/json; charset=utf-8");
                String responseText = post.doPost(this.getPostBody(serviceAlarmMessage));
                boolean isSuccess = this.isSuccess(responseText);
                if (isSuccess) {
                    LOGGER.info("Send ServiceAlarmMessage to DingTalk success. Cost: `{} ms`. ServiceAlarmMessage: `{}`. Url: `{}`. Proxy host: `{}`. Timeout: `{}`. CrashingImageUrl: `{}`. RecoveredImageUrl: `{}`.", new Object[]{System.currentTimeMillis() - startTime, serviceAlarmMessage, this.url, this.proxyHost, this.timeout, this.crashingImageUrl, this.recoveredImageUrl});
                } else {
                    LOGGER.error("Send ServiceAlarmMessage to DingTalk failed. Cost: `{} ms`. ResponseText: `{}`. ServiceAlarmMessage: `{}`. Url: `{}`. Proxy host: `{}`. Timeout: `{}`. CrashingImageUrl: `{}`. RecoveredImageUrl: `{}`.", new Object[]{System.currentTimeMillis() - startTime, responseText, serviceAlarmMessage, this.url, this.proxyHost, this.timeout, this.crashingImageUrl, this.recoveredImageUrl});
                }
                return isSuccess;
            }
            catch (Exception e) {
                LOGGER.error("Send ServiceAlarmMessage to DingTalk failed. Cost: `" + (System.currentTimeMillis() - startTime) + " ms`. ServiceAlarmMessage: `" + serviceAlarmMessage + "`. Url: `" + this.url + "`. Proxy host: `" + this.proxyHost + "`. Timeout: `" + this.timeout + "`. CrashingImageUrl: `" + this.crashingImageUrl + "`. RecoveredImageUrl: `" + this.recoveredImageUrl + "`.", (Throwable)e);
                return false;
            }
        }
        LOGGER.warn("DingTalkServiceAlarmMessageNotifier is inactive. ServiceAlarmMessage: `" + serviceAlarmMessage + "`.");
        return false;
    }

    private String getPostBody(ServiceAlarmMessage serviceAlarmMessage) {
        String title = serviceAlarmMessage.getName() + " \u4e0d\u53ef\u670d\u52a1";
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\"msgtype\":\"markdown\",\"markdown\":{\"title\":\"");
        buffer.append(title).append("\",");
        buffer.append("\"text\":\"");
        buffer.append("# **").append(title).append("** \n");
        buffer.append("#### \u670d\u52a1\u540d\u79f0\uff1a **").append(serviceAlarmMessage.getName()).append("** \n");
        buffer.append("#### \u9879\u76ee\u540d\u79f0\uff1a **").append(serviceAlarmMessage.getProject()).append("** \n");
        buffer.append("#### \u4e3b\u673a\u540d\u79f0\uff1a **").append(serviceAlarmMessage.getHost()).append("** \n");
        buffer.append("#### \u4e0d\u53ef\u7528\u6b21\u6570\uff1a ").append(serviceAlarmMessage.getCrashedTimes()).append("\n");
        buffer.append("#### \u6062\u590d\u6b21\u6570\uff1a ").append(serviceAlarmMessage.getRecoveredTimes()).append("\n");
        if (serviceAlarmMessage.getCrashingRemoteHostSet().isEmpty()) {
            buffer.append("#### \u5f53\u524d\u4e0d\u53ef\u7528\u8fdc\u7a0b\u4e3b\u673a\u5217\u8868\uff1a [ \u65e0 ] \n");
        } else {
            buffer.append("#### \u5f53\u524d\u4e0d\u53ef\u7528\u8fdc\u7a0b\u4e3b\u673a\u5217\u8868\uff1a \n");
            ArrayList<String> crashingRemoteHostList = new ArrayList<String>(serviceAlarmMessage.getCrashingRemoteHostSet());
            Collections.sort(crashingRemoteHostList);
            for (String remoteHost : crashingRemoteHostList) {
                buffer.append("- **").append(remoteHost).append("** \n");
            }
        }
        if (!serviceAlarmMessage.getCrashedRemoteHostSet().isEmpty()) {
            buffer.append("#### \u5386\u53f2\u4e0d\u53ef\u7528\u8fdc\u7a0b\u4e3b\u673a\u5217\u8868\uff1a \n");
            ArrayList<String> crashedRemoteHostList = new ArrayList<String>(serviceAlarmMessage.getCrashedRemoteHostSet());
            Collections.sort(crashedRemoteHostList);
            for (String remoteHost : crashedRemoteHostList) {
                buffer.append("- **").append(remoteHost).append("** \n");
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        buffer.append("#### \u62a5\u8b66\u65f6\u95f4\uff1a **").append(dateFormat.format(serviceAlarmMessage.getCreatedTime())).append("** \n");
        if (!(this.crashingImageUrl.isEmpty() || serviceAlarmMessage.getCrashingRemoteHostSet().isEmpty() && serviceAlarmMessage.getCrashedTimes() <= serviceAlarmMessage.getRecoveredTimes())) {
            buffer.append("![screenshot](").append(this.crashingImageUrl).append(")\n");
        }
        if (!this.recoveredImageUrl.isEmpty() && serviceAlarmMessage.getCrashingRemoteHostSet().isEmpty() && serviceAlarmMessage.getCrashedTimes() <= serviceAlarmMessage.getRecoveredTimes()) {
            buffer.append("![screenshot](").append(this.recoveredImageUrl).append(")\n");
        }
        buffer.append("\"}, \"at\": {\"atMobiles\":[],\"isAtAll\":").append(!serviceAlarmMessage.getCrashingRemoteHostSet().isEmpty()).append("}}");
        return buffer.toString();
    }

    private boolean isSuccess(String responseText) {
        if (responseText != null) {
            responseText = responseText.replace(" ", "").replace("\t", "").replace("\n", "").replace("\r", "");
            return responseText.contains("\"errcode\":0");
        }
        return false;
    }
}

