/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.facility;

import com.heimuheimu.naivemonitor.monitor.SocketMonitor;
import java.io.IOException;
import java.io.InputStream;

public class MonitoredSocketInputStream
extends InputStream {
    private final InputStream in;
    private final SocketMonitor socketMonitor;

    public MonitoredSocketInputStream(InputStream in, SocketMonitor socketMonitor) throws NullPointerException {
        if (in == null) {
            throw new NullPointerException("Create `MonitoredSocketInputStream` failed: `inputStream could not be null`.");
        }
        if (socketMonitor == null) {
            throw new NullPointerException("Create `MonitoredSocketInputStream` failed: `socketMonitor could not be null`.");
        }
        this.in = in;
        this.socketMonitor = socketMonitor;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int readBytes = this.in.read(b);
        if (readBytes >= 0) {
            this.socketMonitor.onRead(readBytes);
        }
        return readBytes;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readBytes = this.in.read(b, off, len);
        if (readBytes >= 0) {
            this.socketMonitor.onRead(readBytes);
        }
        return readBytes;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipBytes = this.in.skip(n);
        if (skipBytes >= 0L) {
            this.socketMonitor.onRead(skipBytes);
        }
        return skipBytes;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        int value = this.in.read();
        if (value >= 0) {
            this.socketMonitor.onRead(1L);
        }
        return value;
    }
}

