/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.facility;

import com.heimuheimu.naivemonitor.monitor.SocketMonitor;
import java.io.IOException;
import java.io.OutputStream;

public class MonitoredSocketOutputStream
extends OutputStream {
    private final OutputStream out;
    private final SocketMonitor socketMonitor;

    public MonitoredSocketOutputStream(OutputStream out, SocketMonitor socketMonitor) throws NullPointerException {
        if (out == null) {
            throw new NullPointerException("Create `MonitoredSocketOutputStream` failed: `outputStream could not be null`.");
        }
        if (socketMonitor == null) {
            throw new NullPointerException("Create `MonitoredSocketOutputStream` failed: `socketMonitor could not be null`.");
        }
        this.out = out;
        this.socketMonitor = socketMonitor;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.socketMonitor.onWritten(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.socketMonitor.onWritten(len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.socketMonitor.onWritten(1L);
    }
}

