/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.falcon;

import com.heimuheimu.naivemonitor.falcon.FalconData;
import com.heimuheimu.naivemonitor.falcon.FalconDataCollector;
import com.heimuheimu.naivemonitor.http.NaiveHttpPost;
import com.heimuheimu.naivemonitor.util.MonitorUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FalconReporter
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FalconReporter.class);
    private final String endpoint;
    private final String pushUrl;
    private final List<FalconDataCollector> falconDataCollectorList;
    private ScheduledExecutorService executorService = null;

    public FalconReporter(String pushUrl, List<FalconDataCollector> falconDataCollectorList) {
        this(pushUrl, falconDataCollectorList, null);
    }

    public FalconReporter(String pushUrl, List<FalconDataCollector> falconDataCollectorList, Map<String, String> endpointAliasMap) throws IllegalArgumentException {
        if (falconDataCollectorList == null || falconDataCollectorList.isEmpty()) {
            LOGGER.error("Construct FalconReporter failed: `falconDataCollectorList is null`. Url: `" + pushUrl + "`.");
            throw new IllegalArgumentException("Construct FalconReporter failed: `falconDataCollectorList is null`. Url: `" + pushUrl + "`.");
        }
        this.pushUrl = pushUrl;
        this.falconDataCollectorList = falconDataCollectorList;
        String endpoint = MonitorUtil.getLocalHostName();
        if (endpointAliasMap != null && endpointAliasMap.containsKey(endpoint)) {
            endpoint = endpointAliasMap.get(endpoint);
        }
        this.endpoint = endpoint;
    }

    public synchronized void init() {
        if (this.executorService == null) {
            int period;
            long startTime = System.currentTimeMillis();
            HashMap<Integer, ArrayList<FalconDataCollector>> collectorMap = new HashMap<Integer, ArrayList<FalconDataCollector>>();
            for (FalconDataCollector collector : this.falconDataCollectorList) {
                period = collector.getPeriod();
                ArrayList<FalconDataCollector> samePeriodCollectors = (ArrayList<FalconDataCollector>)collectorMap.get(period);
                if (samePeriodCollectors == null) {
                    samePeriodCollectors = new ArrayList<FalconDataCollector>();
                    collectorMap.put(period, samePeriodCollectors);
                }
                samePeriodCollectors.add(collector);
            }
            int poolSize = Math.min(3, collectorMap.size());
            this.executorService = Executors.newScheduledThreadPool(poolSize, new ThreadFactory(){
                private final AtomicInteger threadNumber = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setName("naivemonitor-falcon-reporter-" + this.threadNumber.getAndIncrement());
                    t.setDaemon(true);
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            });
            Iterator iterator = collectorMap.keySet().iterator();
            while (iterator.hasNext()) {
                period = (Integer)iterator.next();
                this.executorService.scheduleAtFixedRate(new ReportTask(this.endpoint, this.pushUrl, (List)collectorMap.get(period)), period, period, TimeUnit.SECONDS);
            }
            LOGGER.info("FalconReporter has been initialized. Cost: `{} ms`. Endpoint: `{}`. Push url: `{}`. Pool size: `{}`. Collector map: `{}`.", new Object[]{System.currentTimeMillis() - startTime, this.endpoint, this.pushUrl, poolSize, collectorMap});
        }
    }

    @Override
    public synchronized void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private static class ReportTask
    implements Runnable {
        private final String endpoint;
        private final String pushUrl;
        private final List<FalconDataCollector> falconDataCollectorList;

        public ReportTask(String endpoint, String pushUrl, List<FalconDataCollector> falconDataCollectorList) {
            this.endpoint = endpoint;
            this.pushUrl = pushUrl;
            this.falconDataCollectorList = falconDataCollectorList;
        }

        @Override
        public void run() {
            ArrayList<FalconData> pushDataList = new ArrayList<FalconData>();
            for (FalconDataCollector falconDataCollector : this.falconDataCollectorList) {
                try {
                    pushDataList.addAll(falconDataCollector.getList());
                }
                catch (Exception e) {
                    LOGGER.error("Get falcon data list failed: `" + e.getMessage() + "`. Collector: `" + falconDataCollector + "`.", (Throwable)e);
                }
            }
            if (!pushDataList.isEmpty()) {
                try {
                    for (FalconData pushData : pushDataList) {
                        pushData.setEndpoint(this.endpoint);
                    }
                    String pushJsonData = this.toJson(pushDataList);
                    NaiveHttpPost httpPost = new NaiveHttpPost(this.pushUrl, 5000);
                    httpPost.doPost(pushJsonData);
                    int responseCode = httpPost.getUrlConnection().getResponseCode();
                    if (responseCode != 200) {
                        LOGGER.error("Push falcon data list failed: `error response code [{}]`. Url: `{}`.", (Object)responseCode, (Object)this.pushUrl);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Push falcon data list failed: `" + e.getMessage() + "`. Url: `" + this.pushUrl + "`.", (Throwable)e);
                }
            }
        }

        private String toJson(List<FalconData> pushDataList) {
            StringBuilder buffer = new StringBuilder("[");
            if (!pushDataList.isEmpty()) {
                for (FalconData pushData : pushDataList) {
                    buffer.append(pushData.toJson()).append(",");
                }
                buffer.deleteCharAt(buffer.length() - 1);
            }
            return buffer.append("]").toString();
        }
    }
}

