/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.falcon.support;

import com.heimuheimu.naivemonitor.falcon.FalconData;
import com.heimuheimu.naivemonitor.falcon.support.AbstractFalconDataCollector;
import com.heimuheimu.naivemonitor.monitor.CompressionMonitor;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCompressionDataCollector
extends AbstractFalconDataCollector {
    private volatile long lastCompressedCount = 0L;
    private volatile long lastReduceBytes = 0L;

    protected abstract List<CompressionMonitor> getCompressionMonitorList();

    @Override
    public List<FalconData> getList() {
        List<CompressionMonitor> compressionMonitorList = this.getCompressionMonitorList();
        ArrayList<FalconData> falconDataList = new ArrayList<FalconData>();
        long compressedCount = 0L;
        long reduceBytes = 0L;
        for (CompressionMonitor compressionMonitor : compressionMonitorList) {
            compressedCount += compressionMonitor.getCompressedCount();
            reduceBytes += compressionMonitor.getReduceByteCount();
        }
        falconDataList.add(this.create("_compression_reduce_bytes", reduceBytes - this.lastReduceBytes));
        long averageReduceBytes = 0L;
        if (compressedCount > this.lastCompressedCount) {
            averageReduceBytes = (reduceBytes - this.lastReduceBytes) / (compressedCount - this.lastCompressedCount);
        }
        falconDataList.add(this.create("_compression_avg_reduce_bytes", averageReduceBytes));
        this.lastCompressedCount = compressedCount;
        this.lastReduceBytes = reduceBytes;
        return falconDataList;
    }
}

