/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.falcon.support;

import com.heimuheimu.naivemonitor.falcon.FalconData;
import com.heimuheimu.naivemonitor.falcon.support.AbstractFalconDataCollector;
import com.heimuheimu.naivemonitor.monitor.ExecutionMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractExecutionDataCollector
extends AbstractFalconDataCollector {
    private volatile long lastExecutionCount = 0L;
    private volatile long lastTotalExecutionTime = 0L;
    private final ConcurrentHashMap<Integer, Long> lastErrorCountMap = new ConcurrentHashMap();

    protected abstract List<ExecutionMonitor> getExecutionMonitorList();

    protected Map<Integer, String> getErrorMetricSuffixMap() {
        return null;
    }

    @Override
    public List<FalconData> getList() {
        List<ExecutionMonitor> executionMonitorList = this.getExecutionMonitorList();
        Map<Integer, String> errorMetricSuffixMap = this.getErrorMetricSuffixMap();
        ArrayList<FalconData> falconDataList = new ArrayList<FalconData>();
        long executionCount = 0L;
        long peakTps = 0L;
        HashMap<Integer, Long> errorCountMap = new HashMap<Integer, Long>();
        long totalExecutionTime = 0L;
        long maxExecutionTime = 0L;
        for (ExecutionMonitor executionMonitor : executionMonitorList) {
            executionCount += executionMonitor.getTotalCount();
            long currentPeakTps = executionMonitor.getPeakTps();
            executionMonitor.resetPeakTps();
            long l = peakTps = peakTps < currentPeakTps ? currentPeakTps : peakTps;
            if (errorMetricSuffixMap != null && !errorMetricSuffixMap.isEmpty()) {
                for (Integer errorCode : errorMetricSuffixMap.keySet()) {
                    Long errorCount = (Long)errorCountMap.get(errorCode);
                    if (errorCount == null) {
                        errorCount = 0L;
                    }
                    errorCount = errorCount + executionMonitor.getErrorCount(errorCode);
                    errorCountMap.put(errorCode, errorCount);
                }
            }
            totalExecutionTime += executionMonitor.getTotalExecutionTime();
            long currentMaxExecutionTime = executionMonitor.getMaxExecutionTime();
            executionMonitor.resetMaxExecutionTime();
            maxExecutionTime = maxExecutionTime < currentMaxExecutionTime ? currentMaxExecutionTime : maxExecutionTime;
        }
        falconDataList.add(this.create("_tps", (executionCount - this.lastExecutionCount) / (long)this.getPeriod()));
        falconDataList.add(this.create("_peak_tps", peakTps));
        if (errorMetricSuffixMap != null && !errorMetricSuffixMap.isEmpty()) {
            for (Integer errorCode : errorMetricSuffixMap.keySet()) {
                Long errorCount = (Long)errorCountMap.get(errorCode);
                if (errorCount == null) continue;
                Long lastErrorCount = this.lastErrorCountMap.get(errorCode);
                if (lastErrorCount == null) {
                    lastErrorCount = 0L;
                }
                falconDataList.add(this.create(errorMetricSuffixMap.get(errorCode), errorCount - lastErrorCount));
                this.lastErrorCountMap.put(errorCode, errorCount);
            }
        }
        double avgExecTime = executionCount > this.lastExecutionCount ? (double)((totalExecutionTime - this.lastTotalExecutionTime) / (executionCount - this.lastExecutionCount)) : 0.0;
        falconDataList.add(this.create("_avg_exec_time", avgExecTime));
        this.lastExecutionCount = executionCount;
        this.lastTotalExecutionTime = totalExecutionTime;
        falconDataList.add(this.create("_max_exec_time", maxExecutionTime));
        return falconDataList;
    }
}

