/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.falcon.support;

import com.heimuheimu.naivemonitor.falcon.FalconData;
import com.heimuheimu.naivemonitor.falcon.FalconDataCollector;

public abstract class AbstractFalconDataCollector
implements FalconDataCollector {
    protected abstract String getModuleName();

    protected String getCollectorName() {
        return "";
    }

    protected FalconData create(String metricSuffix, double value) {
        FalconData data = new FalconData();
        data.setStep(this.getPeriod());
        data.setMetric(this.getMetric(metricSuffix));
        data.setTags("module=" + this.getModuleName());
        data.setTimestamp(System.currentTimeMillis() / 1000L);
        data.setValue(value);
        return data;
    }

    private String getMetric(String metricSuffix) {
        if (this.getCollectorName().isEmpty()) {
            return this.getModuleName() + metricSuffix;
        }
        return this.getModuleName() + "_" + this.getCollectorName() + metricSuffix;
    }
}

