/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.falcon.support;

import com.heimuheimu.naivemonitor.falcon.FalconData;
import com.heimuheimu.naivemonitor.falcon.support.AbstractFalconDataCollector;
import com.heimuheimu.naivemonitor.monitor.SocketMonitor;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSocketDataCollector
extends AbstractFalconDataCollector {
    private volatile long lastReadCount = 0L;
    private volatile long lastReadByteCount = 0L;
    private volatile long lastWrittenCount = 0L;
    private volatile long lastWrittenByteCount = 0L;

    protected abstract List<SocketMonitor> getSocketMonitorList();

    @Override
    public List<FalconData> getList() {
        List<SocketMonitor> socketMonitorList = this.getSocketMonitorList();
        ArrayList<FalconData> falconDataList = new ArrayList<FalconData>();
        long readCount = 0L;
        long readByteCount = 0L;
        long writtenCount = 0L;
        long writtenByteCount = 0L;
        long maxReadByteCount = 0L;
        long maxWrittenByteCount = 0L;
        for (SocketMonitor socketMonitor : socketMonitorList) {
            readCount += socketMonitor.getReadCount();
            readByteCount += socketMonitor.getReadByteCount();
            writtenCount += socketMonitor.getWrittenCount();
            writtenByteCount += socketMonitor.getWrittenByteCount();
            long currentMaxReadByteCount = socketMonitor.getMaxReadByteCount();
            socketMonitor.resetMaxReadByteCount();
            maxReadByteCount = maxReadByteCount < currentMaxReadByteCount ? currentMaxReadByteCount : maxReadByteCount;
            long currentMaxWrittenByteCount = socketMonitor.getMaxWrittenByteCount();
            socketMonitor.resetMaxWrittenByteCount();
            maxWrittenByteCount = maxWrittenByteCount < currentMaxWrittenByteCount ? currentMaxWrittenByteCount : maxWrittenByteCount;
        }
        falconDataList.add(this.create("_socket_read_bytes", readByteCount - this.lastReadByteCount));
        long averageReadBytes = 0L;
        if (readCount > this.lastReadCount) {
            averageReadBytes = (readByteCount - this.lastReadByteCount) / (readCount - this.lastReadCount);
        }
        falconDataList.add(this.create("_socket_avg_read_bytes", averageReadBytes));
        falconDataList.add(this.create("_socket_max_read_bytes", maxReadByteCount));
        falconDataList.add(this.create("_socket_written_bytes", writtenByteCount - this.lastWrittenByteCount));
        long averageWrittenBytes = 0L;
        if (writtenCount > this.lastWrittenCount) {
            averageWrittenBytes = (writtenByteCount - this.lastWrittenByteCount) / (writtenCount - this.lastWrittenCount);
        }
        falconDataList.add(this.create("_socket_avg_written_bytes", averageWrittenBytes));
        falconDataList.add(this.create("_socket_max_written_bytes", maxWrittenByteCount));
        this.lastReadCount = readCount;
        this.lastReadByteCount = readByteCount;
        this.lastWrittenCount = writtenCount;
        this.lastWrittenByteCount = writtenByteCount;
        return falconDataList;
    }
}

