/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.falcon.support;

import com.heimuheimu.naivemonitor.falcon.FalconData;
import com.heimuheimu.naivemonitor.falcon.support.AbstractFalconDataCollector;
import com.heimuheimu.naivemonitor.monitor.ThreadPoolMonitor;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractThreadPoolDataCollector
extends AbstractFalconDataCollector {
    private volatile long lastRejectedCount = 0L;

    protected abstract List<ThreadPoolMonitor> getThreadPoolMonitorList();

    @Override
    public List<FalconData> getList() {
        List<ThreadPoolMonitor> threadPoolMonitorList = this.getThreadPoolMonitorList();
        ArrayList<FalconData> falconDataList = new ArrayList<FalconData>();
        long activeCount = 0L;
        long poolSize = 0L;
        long peakPoolSize = 0L;
        long corePoolSize = 0L;
        long maximumPoolSize = 0L;
        long rejectedCount = 0L;
        for (ThreadPoolMonitor threadPoolMonitor : threadPoolMonitorList) {
            activeCount += (long)threadPoolMonitor.getActiveCount();
            poolSize += (long)threadPoolMonitor.getPoolSize();
            peakPoolSize += (long)threadPoolMonitor.getPeakPoolSize();
            corePoolSize += (long)threadPoolMonitor.getCorePoolSize();
            maximumPoolSize += (long)threadPoolMonitor.getMaximumPoolSize();
            rejectedCount += threadPoolMonitor.getRejectedCount();
        }
        falconDataList.add(this.create("_threadPool_active_count", activeCount));
        falconDataList.add(this.create("_threadPool_pool_size", poolSize));
        falconDataList.add(this.create("_threadPool_peak_pool_size", peakPoolSize));
        falconDataList.add(this.create("_threadPool_core_pool_size", corePoolSize));
        falconDataList.add(this.create("_threadPool_maximum_pool_size", maximumPoolSize));
        falconDataList.add(this.create("_threadPool_rejected_count", rejectedCount - this.lastRejectedCount));
        this.lastRejectedCount = rejectedCount;
        return falconDataList;
    }
}

