/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.falcon.support;

import com.heimuheimu.naivemonitor.falcon.FalconData;
import com.heimuheimu.naivemonitor.falcon.support.AbstractExecutionDataCollector;
import com.heimuheimu.naivemonitor.monitor.ExecutionMonitor;
import com.heimuheimu.naivemonitor.monitor.SqlExecutionMonitor;
import com.heimuheimu.naivemonitor.monitor.factory.NaiveSqlExecutionMonitorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlExecutionDataCollector
extends AbstractExecutionDataCollector {
    private static final Map<Integer, String> ERROR_METRIC_SUFFIX_MAP = new HashMap<Integer, String>();
    private final String moduleName;
    private final String collectorName;
    private final SqlExecutionMonitor sqlExecutionMonitor;
    private final List<ExecutionMonitor> executionMonitorList;

    public SqlExecutionDataCollector(String moduleName, String dbName) {
        this.moduleName = moduleName;
        this.collectorName = dbName + "_sql";
        this.sqlExecutionMonitor = NaiveSqlExecutionMonitorFactory.get(dbName);
        this.executionMonitorList = new ArrayList<ExecutionMonitor>();
        this.executionMonitorList.add(this.sqlExecutionMonitor.getExecutionMonitor());
    }

    @Override
    public int getPeriod() {
        return 30;
    }

    @Override
    public List<FalconData> getList() {
        ArrayList<FalconData> falconDataList = new ArrayList<FalconData>();
        falconDataList.addAll(super.getList());
        falconDataList.add(this.create("_max_result_size", this.sqlExecutionMonitor.getMaxResultSize()));
        this.sqlExecutionMonitor.resetMaxResultSize();
        falconDataList.add(this.create("_max_updated_rows", this.sqlExecutionMonitor.getMaxUpdatedRows()));
        this.sqlExecutionMonitor.resetMaxUpdatedRows();
        falconDataList.add(this.create("_max_deleted_rows", this.sqlExecutionMonitor.getMaxDeletedRows()));
        this.sqlExecutionMonitor.resetMaxDeletedRows();
        return falconDataList;
    }

    @Override
    protected List<ExecutionMonitor> getExecutionMonitorList() {
        return this.executionMonitorList;
    }

    @Override
    protected String getModuleName() {
        return this.moduleName;
    }

    @Override
    protected String getCollectorName() {
        return this.collectorName;
    }

    @Override
    protected Map<Integer, String> getErrorMetricSuffixMap() {
        return ERROR_METRIC_SUFFIX_MAP;
    }

    static {
        ERROR_METRIC_SUFFIX_MAP.put(-1, "_error");
        ERROR_METRIC_SUFFIX_MAP.put(-2, "_slow_execution");
    }
}

