/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaiveHttpPost {
    private static final Logger LOGGER = LoggerFactory.getLogger(NaiveHttpPost.class);
    private final String url;
    private final HttpURLConnection urlConnection;
    private boolean isExecuted = false;

    public NaiveHttpPost(String url, int timeout) throws IOException {
        this(url, timeout, null);
    }

    public NaiveHttpPost(String url, int timeout, String proxyHost) throws IllegalArgumentException, IOException {
        Proxy proxy = null;
        if (proxyHost != null && !proxyHost.trim().isEmpty()) {
            try {
                String[] hostParts = proxyHost.split(":");
                String hostname = hostParts[0];
                int port = Integer.parseInt(hostParts[1]);
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port));
            }
            catch (Exception e) {
                LOGGER.error("Create NaiveHttpPost failed: `invalid proxy host`. Url: `" + url + "`. Timeout: `" + timeout + "`. Proxy host: `" + proxyHost + "`.", (Throwable)e);
                throw new IllegalArgumentException("Create NaiveHttpPost failed: `invalid proxy host`. Url: `" + url + "`. Timeout: `" + timeout + "`. Proxy host: `" + proxyHost + "`.", e);
            }
        }
        try {
            this.url = url;
            this.urlConnection = proxy == null ? (HttpURLConnection)new URL(url).openConnection() : (HttpURLConnection)new URL(url).openConnection(proxy);
            this.urlConnection.setConnectTimeout(timeout);
            this.urlConnection.setReadTimeout(timeout);
            this.urlConnection.setRequestMethod("POST");
            this.urlConnection.setDoOutput(true);
        }
        catch (Exception e) {
            LOGGER.error("Create NaiveHttpPost failed: `" + e.getMessage() + "`. Url: `" + url + "`. Timeout: `" + timeout + "`. Proxy host: `" + proxyHost + "`.", (Throwable)e);
            throw e;
        }
    }

    public HttpURLConnection getUrlConnection() {
        return this.urlConnection;
    }

    public synchronized String doPost(String body) throws IllegalStateException, IllegalArgumentException, IOException {
        if (this.isExecuted) {
            LOGGER.error("Execute http post method failed: `#doPost(String) has been executed already`. Url: `{}`. Body: `{}`.", (Object)this.url, (Object)body);
            throw new IllegalStateException("Execute http post method failed: `#doPost(String) has been executed already`. Url: `" + this.url + "`. Body: `" + body + "`.");
        }
        if (body == null || body.isEmpty()) {
            LOGGER.error("Execute http post method failed: `post body could not be null or empty`. Url: `{}`. Body: `{}`.", (Object)this.url, (Object)body);
            throw new IllegalArgumentException("Execute http post method failed: `post body could not be null or empty`. Url: `" + this.url + "`. Body: `" + body + "`.");
        }
        long startTime = System.currentTimeMillis();
        OutputStream os = null;
        InputStream is = null;
        try {
            String line;
            byte[] bodyBytes = body.getBytes("utf-8");
            os = this.urlConnection.getOutputStream();
            os.write(bodyBytes);
            os.flush();
            is = this.urlConnection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
            StringBuilder responseTextBuffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                responseTextBuffer.append(line);
            }
            String responseText = responseTextBuffer.toString();
            LOGGER.info("Execute http post success. Cost: `{} ms`. Url: `{}`. Body: `{}`. Response text: `{}`.", new Object[]{System.currentTimeMillis() - startTime, this.url, body, responseText});
            String string = responseText;
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Execute http post method failed: `" + e.getMessage() + "`. Url: `" + this.url + "`. Body: `" + body + "`.", (Throwable)e);
            throw e;
        }
        finally {
            this.isExecuted = true;
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            try {
                this.urlConnection.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public static String getPostBody(Map<String, Object> params) {
        if (params != null && !params.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            for (String paramName : params.keySet()) {
                String value = String.valueOf(params.get(paramName));
                try {
                    value = URLEncoder.encode(value, "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                buffer.append(paramName).append("=").append(value).append("&");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            return buffer.toString();
        }
        return "";
    }
}

