/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.ibatis;

import com.heimuheimu.naivemonitor.monitor.SqlExecutionMonitor;
import com.heimuheimu.naivemonitor.monitor.factory.NaiveSqlExecutionMonitorFactory;
import com.ibatis.sqlmap.client.SqlMapClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

public class SmartSqlMapClientTemplate
extends SqlMapClientTemplate {
    private static final Logger SQL_ERROR_EXECUTION_LOGGER = LoggerFactory.getLogger((String)"NAIVESQL_ERROR_EXECUTION_LOGGER");
    private static final Logger SQL_SLOW_EXECUTION_LOGGER = LoggerFactory.getLogger((String)"NAIVESQL_SLOW_EXECUTION_LOGGER");
    private final String dbName;
    private final long slowExecutionThreshold;
    private final SqlExecutionMonitor sqlExecutionMonitor;

    public SmartSqlMapClientTemplate(String dbName, SqlMapClient sqlMapClient, long slowExecutionThreshold) {
        super(sqlMapClient);
        this.dbName = dbName;
        this.slowExecutionThreshold = TimeUnit.NANOSECONDS.convert(slowExecutionThreshold, TimeUnit.MILLISECONDS);
        this.sqlExecutionMonitor = NaiveSqlExecutionMonitorFactory.get(dbName);
    }

    public SmartSqlMapClientTemplate(String dbName, DataSource dataSource, SqlMapClient sqlMapClient, long slowExecutionThreshold) {
        super(dataSource, sqlMapClient);
        this.dbName = dbName;
        this.slowExecutionThreshold = TimeUnit.NANOSECONDS.convert(slowExecutionThreshold, TimeUnit.MILLISECONDS);
        this.sqlExecutionMonitor = NaiveSqlExecutionMonitorFactory.get(dbName);
    }

    public Object queryForObject(String statementName) throws DataAccessException {
        return this.queryForObject(statementName, null);
    }

    public Object queryForObject(String statementName, Object parameterObject) throws DataAccessException {
        Object object;
        long startTime = System.nanoTime();
        try {
            object = super.queryForObject(statementName, parameterObject);
            this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
        }
        catch (Exception e) {
            try {
                this.sqlExecutionMonitor.getExecutionMonitor().onError(-1);
                SQL_ERROR_EXECUTION_LOGGER.error("Query for object failed: `" + e.getMessage() + "`. Db name: `" + this.dbName + "`. Statement name: `" + statementName + "`. Parameter: `" + parameterObject + "`.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
                long executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
                    SQL_SLOW_EXECUTION_LOGGER.error("[queryForObject] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject});
                }
                throw throwable;
            }
        }
        long executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
            SQL_SLOW_EXECUTION_LOGGER.error("[queryForObject] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject});
        }
        return object;
    }

    public Object queryForObject(String statementName, Object parameterObject, Object resultObject) throws DataAccessException {
        Object object;
        long startTime = System.nanoTime();
        try {
            object = super.queryForObject(statementName, parameterObject, resultObject);
            this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
        }
        catch (Exception e) {
            try {
                this.sqlExecutionMonitor.getExecutionMonitor().onError(-1);
                SQL_ERROR_EXECUTION_LOGGER.error("Query for object failed: `" + e.getMessage() + "`. Db name: `" + this.dbName + "`. Statement name: `" + statementName + "`. Parameter: `" + parameterObject + "`. Result object: `" + resultObject + "`.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
                long executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
                    SQL_SLOW_EXECUTION_LOGGER.error("[queryForObject] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Result object: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, resultObject});
                }
                throw throwable;
            }
        }
        long executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
            SQL_SLOW_EXECUTION_LOGGER.error("[queryForObject] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Result object: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, resultObject});
        }
        return object;
    }

    public List queryForList(String statementName) throws DataAccessException {
        return this.queryForList(statementName, null);
    }

    public List queryForList(String statementName, Object parameterObject) throws DataAccessException {
        List list;
        long startTime = System.nanoTime();
        int resultSize = 0;
        try {
            List result = super.queryForList(statementName, parameterObject);
            resultSize = result.size();
            this.sqlExecutionMonitor.onQueryList(resultSize);
            list = result;
            this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
        }
        catch (Exception e) {
            try {
                this.sqlExecutionMonitor.getExecutionMonitor().onError(-1);
                SQL_ERROR_EXECUTION_LOGGER.error("Query for list failed: `" + e.getMessage() + "`. Db name: `" + this.dbName + "`. Statement name: `" + statementName + "`. Parameter: `" + parameterObject + "`.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
                long executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
                    SQL_SLOW_EXECUTION_LOGGER.error("[queryForList] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Result size: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, resultSize});
                }
                throw throwable;
            }
        }
        long executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
            SQL_SLOW_EXECUTION_LOGGER.error("[queryForList] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Result size: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, resultSize});
        }
        return list;
    }

    public List queryForList(String statementName, int skipResults, int maxResults) throws DataAccessException {
        return this.queryForList(statementName, null, skipResults, maxResults);
    }

    public List queryForList(String statementName, Object parameterObject, int skipResults, int maxResults) throws DataAccessException {
        List list;
        long startTime = System.nanoTime();
        int resultSize = 0;
        try {
            List result = super.queryForList(statementName, parameterObject, skipResults, maxResults);
            resultSize = result.size();
            this.sqlExecutionMonitor.onQueryList(resultSize);
            list = result;
            this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
        }
        catch (Exception e) {
            try {
                this.sqlExecutionMonitor.getExecutionMonitor().onError(-1);
                SQL_ERROR_EXECUTION_LOGGER.error("Query for list failed: `" + e.getMessage() + "`. Db name: `" + this.dbName + "`. Statement name: `" + statementName + "`. Parameter: `" + parameterObject + "`. Skip results: `" + skipResults + "`. Max results: `" + maxResults + "`.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
                long executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
                    SQL_SLOW_EXECUTION_LOGGER.error("[queryForList] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Result size: `{}`. Skip results: `{}`. Max results: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, resultSize, skipResults, maxResults});
                }
                throw throwable;
            }
        }
        long executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
            SQL_SLOW_EXECUTION_LOGGER.error("[queryForList] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Result size: `{}`. Skip results: `{}`. Max results: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, resultSize, skipResults, maxResults});
        }
        return list;
    }

    public Map queryForMap(String statementName, Object parameterObject, String keyProperty) throws DataAccessException {
        Map map;
        long startTime = System.nanoTime();
        int resultSize = 0;
        try {
            Map result = super.queryForMap(statementName, parameterObject, keyProperty);
            resultSize = result.size();
            this.sqlExecutionMonitor.onQueryList(resultSize);
            map = result;
            this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
        }
        catch (Exception e) {
            try {
                this.sqlExecutionMonitor.getExecutionMonitor().onError(-1);
                SQL_ERROR_EXECUTION_LOGGER.error("Query for map failed: `" + e.getMessage() + "`. Db name: `" + this.dbName + "`. Statement name: `" + statementName + "`. Parameter: `" + parameterObject + "`. Key property: `" + keyProperty + "`.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
                long executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
                    SQL_SLOW_EXECUTION_LOGGER.error("[queryForMap] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Key property: `{}`. Result size: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, keyProperty, resultSize});
                }
                throw throwable;
            }
        }
        long executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
            SQL_SLOW_EXECUTION_LOGGER.error("[queryForMap] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Key property: `{}`. Result size: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, keyProperty, resultSize});
        }
        return map;
    }

    public Map queryForMap(String statementName, Object parameterObject, String keyProperty, String valueProperty) throws DataAccessException {
        Map map;
        long startTime = System.nanoTime();
        int resultSize = 0;
        try {
            Map result = super.queryForMap(statementName, parameterObject, keyProperty, valueProperty);
            resultSize = result.size();
            this.sqlExecutionMonitor.onQueryList(resultSize);
            map = result;
            this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
        }
        catch (Exception e) {
            try {
                this.sqlExecutionMonitor.getExecutionMonitor().onError(-1);
                SQL_ERROR_EXECUTION_LOGGER.error("Query for map failed: `" + e.getMessage() + "`. Db name: `" + this.dbName + "`. Statement name: `" + statementName + "`. Parameter: `" + parameterObject + "`. Key property: `" + keyProperty + "`. Value property: `" + valueProperty + "`.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
                long executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
                    SQL_SLOW_EXECUTION_LOGGER.error("[queryForMap] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Key property: `{}`. Value property: `{}`. Result size: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, keyProperty, valueProperty, resultSize});
                }
                throw throwable;
            }
        }
        long executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
            SQL_SLOW_EXECUTION_LOGGER.error("[queryForMap] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Key property: `{}`. Value property: `{}`. Result size: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, keyProperty, valueProperty, resultSize});
        }
        return map;
    }

    public Object insert(String statementName) throws DataAccessException {
        return this.insert(statementName, null);
    }

    public Object insert(String statementName, Object parameterObject) throws DataAccessException {
        Object object;
        long startTime = System.nanoTime();
        try {
            object = super.insert(statementName, parameterObject);
            this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
        }
        catch (Exception e) {
            try {
                this.sqlExecutionMonitor.getExecutionMonitor().onError(-1);
                SQL_ERROR_EXECUTION_LOGGER.error("Insert failed: `" + e.getMessage() + "`. Db name: `" + this.dbName + "`. Statement name: `" + statementName + "`. Parameter: `" + parameterObject + "`.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
                long executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
                    SQL_SLOW_EXECUTION_LOGGER.error("[insert] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject});
                }
                throw throwable;
            }
        }
        long executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
            SQL_SLOW_EXECUTION_LOGGER.error("[insert] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject});
        }
        return object;
    }

    public int update(String statementName) throws DataAccessException {
        return this.update(statementName, null);
    }

    public int update(String statementName, Object parameterObject) throws DataAccessException {
        int n;
        long startTime = System.nanoTime();
        int updatedRows = 0;
        try {
            updatedRows = super.update(statementName, parameterObject);
            this.sqlExecutionMonitor.onUpdated(updatedRows);
            n = updatedRows;
            this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
        }
        catch (Exception e) {
            try {
                this.sqlExecutionMonitor.getExecutionMonitor().onError(-1);
                SQL_ERROR_EXECUTION_LOGGER.error("Update failed: `" + e.getMessage() + "`. Db name: `" + this.dbName + "`. Statement name: `" + statementName + "`. Parameter: `" + parameterObject + "`.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
                long executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
                    SQL_SLOW_EXECUTION_LOGGER.error("[update] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Updated rows: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, updatedRows});
                }
                throw throwable;
            }
        }
        long executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
            SQL_SLOW_EXECUTION_LOGGER.error("[update] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Updated rows: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, updatedRows});
        }
        return n;
    }

    public void update(String statementName, Object parameterObject, int requiredRowsAffected) throws DataAccessException {
        long startTime = System.nanoTime();
        try {
            super.update(statementName, parameterObject, requiredRowsAffected);
            this.sqlExecutionMonitor.onUpdated(requiredRowsAffected);
            this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
        }
        catch (Exception e) {
            try {
                this.sqlExecutionMonitor.getExecutionMonitor().onError(-1);
                SQL_ERROR_EXECUTION_LOGGER.error("Update failed: `" + e.getMessage() + "`. Db name: `" + this.dbName + "`. Statement name: `" + statementName + "`. Parameter: `" + parameterObject + "`. Required rows affected: `" + requiredRowsAffected + "`.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
                long executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
                    SQL_SLOW_EXECUTION_LOGGER.error("[update] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Required rows affected: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, requiredRowsAffected});
                }
                throw throwable;
            }
        }
        long executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
            SQL_SLOW_EXECUTION_LOGGER.error("[update] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Required rows affected: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, requiredRowsAffected});
        }
    }

    public int delete(String statementName) throws DataAccessException {
        return this.delete(statementName, null);
    }

    public int delete(String statementName, Object parameterObject) throws DataAccessException {
        int n;
        long startTime = System.nanoTime();
        int deletedRows = 0;
        try {
            deletedRows = super.delete(statementName, parameterObject);
            this.sqlExecutionMonitor.onDeleted(deletedRows);
            n = deletedRows;
            this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
        }
        catch (Exception e) {
            try {
                this.sqlExecutionMonitor.getExecutionMonitor().onError(-1);
                SQL_ERROR_EXECUTION_LOGGER.error("Delete failed: `" + e.getMessage() + "`. Db name: `" + this.dbName + "`. Statement name: `" + statementName + "`. Parameter: `" + parameterObject + "`.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
                long executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
                    SQL_SLOW_EXECUTION_LOGGER.error("[delete] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Deleted rows: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, deletedRows});
                }
                throw throwable;
            }
        }
        long executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
            SQL_SLOW_EXECUTION_LOGGER.error("[delete] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Deleted rows: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, deletedRows});
        }
        return n;
    }

    public void delete(String statementName, Object parameterObject, int requiredRowsAffected) throws DataAccessException {
        long startTime = System.nanoTime();
        try {
            super.delete(statementName, parameterObject, requiredRowsAffected);
            this.sqlExecutionMonitor.onDeleted(requiredRowsAffected);
            this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
        }
        catch (Exception e) {
            try {
                this.sqlExecutionMonitor.getExecutionMonitor().onError(-1);
                SQL_ERROR_EXECUTION_LOGGER.error("Delete failed: `" + e.getMessage() + "`. Db name: `" + this.dbName + "`. Statement name: `" + statementName + "`. Parameter: `" + parameterObject + "`. Required rows affected: `" + requiredRowsAffected + "`.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.sqlExecutionMonitor.getExecutionMonitor().onExecuted(startTime);
                long executedNanoTime = System.nanoTime() - startTime;
                if (executedNanoTime > this.slowExecutionThreshold) {
                    this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
                    SQL_SLOW_EXECUTION_LOGGER.error("[delete] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Required rows affected: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, requiredRowsAffected});
                }
                throw throwable;
            }
        }
        long executedNanoTime = System.nanoTime() - startTime;
        if (executedNanoTime > this.slowExecutionThreshold) {
            this.sqlExecutionMonitor.getExecutionMonitor().onError(-2);
            SQL_SLOW_EXECUTION_LOGGER.error("[delete] Cost: `{}ns ({})ms`. Db name: `{}`. Statement name: `{}`. Parameter: `{}`. Required rows affected: `{}`.", new Object[]{executedNanoTime, TimeUnit.MILLISECONDS.convert(executedNanoTime, TimeUnit.NANOSECONDS), this.dbName, statementName, parameterObject, requiredRowsAffected});
        }
    }
}

