/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.monitor;

import com.heimuheimu.naivemonitor.util.MonitorUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ExecutionMonitor {
    private final AtomicLong totalCount = new AtomicLong();
    private final ConcurrentHashMap<Integer, AtomicLong> errorCountMap = new ConcurrentHashMap();
    private volatile long peakTps = 0L;
    private final AtomicLong currentTps = new AtomicLong();
    private volatile long currentTpsTimestamp = 0L;
    private volatile long maxExecutionTime = 0L;
    private final AtomicLong totalExecutionTime = new AtomicLong();

    public void onExecuted(long startNanoTime) {
        long estimatedTime = System.nanoTime() - startNanoTime;
        if (estimatedTime > this.maxExecutionTime) {
            this.maxExecutionTime = estimatedTime;
        }
        MonitorUtil.safeAdd(this.totalCount, 1L);
        MonitorUtil.safeAdd(this.totalExecutionTime, estimatedTime);
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp - this.currentTpsTimestamp <= 1000L) {
            this.currentTps.incrementAndGet();
        } else {
            long currentTpsValue = this.currentTps.get();
            this.currentTps.set(0L);
            this.currentTpsTimestamp = currentTimestamp;
            if (currentTpsValue > this.peakTps) {
                this.peakTps = currentTpsValue;
            }
        }
    }

    public void onError(int errorCode) {
        AtomicLong existedErrorCount = this.errorCountMap.get(errorCode);
        if (existedErrorCount == null) {
            existedErrorCount = new AtomicLong();
            this.errorCountMap.put(errorCode, existedErrorCount);
        }
        MonitorUtil.safeAdd(existedErrorCount, 1L);
    }

    public long getTotalCount() {
        return this.totalCount.get();
    }

    public long getErrorCount(int errorCode) {
        AtomicLong errorCount = this.errorCountMap.get(errorCode);
        if (errorCount != null) {
            return errorCount.get();
        }
        return 0L;
    }

    public long getPeakTps() {
        return this.peakTps;
    }

    public long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public long getTotalExecutionTime() {
        return this.totalExecutionTime.get();
    }

    public void resetMaxExecutionTime() {
        this.maxExecutionTime = 0L;
    }

    public void resetPeakTps() {
        this.peakTps = 0L;
    }

    public String toString() {
        return "ExecutionMonitor{totalCount=" + this.totalCount + ", errorCountMap=" + this.errorCountMap + ", peakTps=" + this.peakTps + ", currentTps=" + this.currentTps + ", currentTpsTimestamp=" + this.currentTpsTimestamp + ", maxExecutionTime=" + this.maxExecutionTime + ", totalExecutionTime=" + this.totalExecutionTime + '}';
    }
}

