/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.monitor;

import com.heimuheimu.naivemonitor.util.MonitorUtil;
import java.util.concurrent.atomic.AtomicLong;

public class SocketMonitor {
    private final String host;
    private final AtomicLong readCount = new AtomicLong();
    private final AtomicLong readByteCount = new AtomicLong();
    private volatile long maxReadByteCount = 0L;
    private final AtomicLong writtenCount = new AtomicLong();
    private final AtomicLong writtenByteCount = new AtomicLong();
    private volatile long maxWrittenByteCount = 0L;

    public SocketMonitor(String host) {
        this.host = host == null ? "" : host.trim();
    }

    public void onRead(long byteCount) {
        MonitorUtil.safeAdd(this.readCount, 1L);
        MonitorUtil.safeAdd(this.readByteCount, byteCount);
        if (byteCount > this.maxReadByteCount) {
            this.maxReadByteCount = byteCount;
        }
    }

    public void onWritten(long byteCount) {
        MonitorUtil.safeAdd(this.writtenCount, 1L);
        MonitorUtil.safeAdd(this.writtenByteCount, byteCount);
        if (byteCount > this.maxWrittenByteCount) {
            this.maxWrittenByteCount = byteCount;
        }
    }

    public void resetMaxReadByteCount() {
        this.maxReadByteCount = 0L;
    }

    public void resetMaxWrittenByteCount() {
        this.maxWrittenByteCount = 0L;
    }

    public String getHost() {
        return this.host;
    }

    public long getReadCount() {
        return this.readCount.get();
    }

    public long getReadByteCount() {
        return this.readByteCount.get();
    }

    public long getMaxReadByteCount() {
        return this.maxReadByteCount;
    }

    public long getWrittenCount() {
        return this.writtenCount.get();
    }

    public long getWrittenByteCount() {
        return this.writtenByteCount.get();
    }

    public long getMaxWrittenByteCount() {
        return this.maxWrittenByteCount;
    }

    public String toString() {
        return "SocketMonitor{host='" + this.host + '\'' + ", readCount=" + this.readCount + ", readByteCount=" + this.readByteCount + ", maxReadByteCount=" + this.maxReadByteCount + ", writtenCount=" + this.writtenCount + ", writtenByteCount=" + this.writtenByteCount + ", maxWrittenByteCount=" + this.maxWrittenByteCount + '}';
    }
}

