/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.monitor;

import com.heimuheimu.naivemonitor.monitor.ExecutionMonitor;

public class SqlExecutionMonitor {
    private final ExecutionMonitor executionMonitor = new ExecutionMonitor();
    private volatile long maxResultSize = 0L;
    private volatile long maxUpdatedRows = 0L;
    private volatile long maxDeletedRows = 0L;

    public void onQueryList(int resultSize) {
        if ((long)resultSize > this.maxResultSize) {
            this.maxResultSize = resultSize;
        }
    }

    public void onUpdated(int updatedRows) {
        if ((long)updatedRows > this.maxUpdatedRows) {
            this.maxUpdatedRows = updatedRows;
        }
    }

    public void onDeleted(int deletedRows) {
        if ((long)deletedRows > this.maxDeletedRows) {
            this.maxDeletedRows = deletedRows;
        }
    }

    public ExecutionMonitor getExecutionMonitor() {
        return this.executionMonitor;
    }

    public long getMaxResultSize() {
        return this.maxResultSize;
    }

    public long getMaxUpdatedRows() {
        return this.maxUpdatedRows;
    }

    public long getMaxDeletedRows() {
        return this.maxDeletedRows;
    }

    public void resetMaxResultSize() {
        this.maxResultSize = 0L;
    }

    public void resetMaxUpdatedRows() {
        this.maxUpdatedRows = 0L;
    }

    public void resetMaxDeletedRows() {
        this.maxDeletedRows = 0L;
    }

    public String toString() {
        return "SqlExecutionMonitor{executionMonitor=" + this.executionMonitor + ", maxResultSize=" + this.maxResultSize + ", maxUpdatedRows=" + this.maxUpdatedRows + ", maxDeletedRows=" + this.maxDeletedRows + '}';
    }
}

