/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.monitor;

import com.heimuheimu.naivemonitor.util.MonitorUtil;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolMonitor.class);
    private final CopyOnWriteArrayList<ThreadPoolExecutor> currentThreadPoolList = new CopyOnWriteArrayList();
    private final AtomicLong rejectedCount = new AtomicLong();

    public void register(ThreadPoolExecutor executor) {
        if (executor != null) {
            this.currentThreadPoolList.add(executor);
        }
    }

    public void onRejected() {
        MonitorUtil.safeAdd(this.rejectedCount, 1L);
    }

    public long getRejectedCount() {
        return this.rejectedCount.get();
    }

    public int getActiveCount() {
        int activeCount = 0;
        try {
            for (ThreadPoolExecutor executor : this.currentThreadPoolList) {
                if (executor == null) continue;
                if (!executor.isShutdown()) {
                    activeCount += executor.getActiveCount();
                    continue;
                }
                this.currentThreadPoolList.remove(executor);
            }
            return activeCount;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error. Current thread pool list: `" + this.currentThreadPoolList + "`.", (Throwable)e);
            return -1;
        }
    }

    public int getCorePoolSize() {
        int corePoolSize = 0;
        try {
            for (ThreadPoolExecutor executor : this.currentThreadPoolList) {
                if (executor == null) continue;
                if (!executor.isShutdown()) {
                    corePoolSize += executor.getCorePoolSize();
                    continue;
                }
                this.currentThreadPoolList.remove(executor);
            }
            return corePoolSize;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error. Current thread pool list: `" + this.currentThreadPoolList + "`.", (Throwable)e);
            return -1;
        }
    }

    public int getMaximumPoolSize() {
        int maximumPoolSize = 0;
        try {
            for (ThreadPoolExecutor executor : this.currentThreadPoolList) {
                if (executor == null) continue;
                if (!executor.isShutdown()) {
                    maximumPoolSize += executor.getMaximumPoolSize();
                    continue;
                }
                this.currentThreadPoolList.remove(executor);
            }
            return maximumPoolSize;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error. Current thread pool list: `" + this.currentThreadPoolList + "`.", (Throwable)e);
            return -1;
        }
    }

    public int getPoolSize() {
        int poolSize = 0;
        try {
            for (ThreadPoolExecutor executor : this.currentThreadPoolList) {
                if (executor == null) continue;
                if (!executor.isShutdown()) {
                    poolSize += executor.getPoolSize();
                    continue;
                }
                this.currentThreadPoolList.remove(executor);
            }
            return poolSize;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error. Current thread pool list: `" + this.currentThreadPoolList + "`.", (Throwable)e);
            return -1;
        }
    }

    public int getPeakPoolSize() {
        int peakPoolSize = 0;
        try {
            for (ThreadPoolExecutor executor : this.currentThreadPoolList) {
                if (executor == null) continue;
                if (!executor.isShutdown()) {
                    peakPoolSize += executor.getLargestPoolSize();
                    continue;
                }
                this.currentThreadPoolList.remove(executor);
            }
            return peakPoolSize;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error. Current thread pool list: `" + this.currentThreadPoolList + "`.", (Throwable)e);
            return -1;
        }
    }

    public String toString() {
        return "ThreadPoolMonitor{currentThreadPoolList=" + this.currentThreadPoolList + ", rejectedCount=" + this.rejectedCount + '}';
    }
}

