/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.monitor.factory;

import com.heimuheimu.naivemonitor.monitor.CompressionMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class NaiveCompressionMonitorFactory {
    private static final ConcurrentHashMap<String, CompressionMonitor> COMPRESSION_MONITOR_MAP = new ConcurrentHashMap();
    private static final Object lock = new Object();

    private NaiveCompressionMonitorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompressionMonitor get(String name) {
        CompressionMonitor monitor = COMPRESSION_MONITOR_MAP.get(name);
        if (monitor == null) {
            Object object = lock;
            synchronized (object) {
                monitor = COMPRESSION_MONITOR_MAP.get(name);
                if (monitor == null) {
                    monitor = new CompressionMonitor();
                    COMPRESSION_MONITOR_MAP.put(name, monitor);
                }
            }
        }
        return monitor;
    }

    public static List<CompressionMonitor> getAll() {
        return new ArrayList<CompressionMonitor>(COMPRESSION_MONITOR_MAP.values());
    }
}

