/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.monitor.factory;

import com.heimuheimu.naivemonitor.monitor.ExecutionMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class NaiveExecutionMonitorFactory {
    private static final ConcurrentHashMap<String, ExecutionMonitor> EXECUTION_MONITOR_MAP = new ConcurrentHashMap();
    private static final Object lock = new Object();

    private NaiveExecutionMonitorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionMonitor get(String name) {
        ExecutionMonitor monitor = EXECUTION_MONITOR_MAP.get(name);
        if (monitor == null) {
            Object object = lock;
            synchronized (object) {
                monitor = EXECUTION_MONITOR_MAP.get(name);
                if (monitor == null) {
                    monitor = new ExecutionMonitor();
                    EXECUTION_MONITOR_MAP.put(name, monitor);
                }
            }
        }
        return monitor;
    }

    public static List<ExecutionMonitor> getAll() {
        return new ArrayList<ExecutionMonitor>(EXECUTION_MONITOR_MAP.values());
    }
}

