/*
 * Decompiled with CFR 0.152.
 */
package com.heimuheimu.naivemonitor.util;

import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorUtil.class);
    private static final String LOCAL_HOST_NAME;

    private MonitorUtil() {
    }

    public static long safeAdd(AtomicLong target, long delta) {
        long value = target.addAndGet(delta);
        if (value >= 0L) {
            return value;
        }
        target.set(0L);
        return 0L;
    }

    public static String getLocalHostName() {
        return LOCAL_HOST_NAME;
    }

    static {
        String endpoint = "InetAddress.getLocalHost().getHostName() failed.";
        try {
            endpoint = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOGGER.error("Get local host name failed.", (Throwable)e);
        }
        finally {
            LOCAL_HOST_NAME = endpoint;
        }
    }
}

