/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.as2servlet;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.processor.module.AbstractProcessorModule;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.as2servlet.AS2PeppolServletConfiguration;
import com.helger.peppol.as2servlet.EPeppolAS2Version;
import com.helger.peppol.as2servlet.IAS2IncomingSBDHandlerSPI;
import com.helger.peppol.sbdh.PeppolSBDHDocument;
import com.helger.peppol.sbdh.read.PeppolSBDHDocumentReader;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.sbdh.SBDMarshaller;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.peppol.ISMPServiceMetadataProvider;
import com.helger.smpclient.peppol.SMPClientReadOnly;
import com.helger.smpclient.peppol.jaxb.EndpointType;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;

public class AS2ServletSBDModule
extends AbstractProcessorModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2ServletSBDModule.class);
    private EPeppolAS2Version m_eAS2Version;
    private final ICommonsList<IAS2IncomingSBDHandlerSPI> m_aHandlers;

    @Deprecated
    public AS2ServletSBDModule() {
        this(EPeppolAS2Version.V2);
    }

    public AS2ServletSBDModule(@Nonnull EPeppolAS2Version ePeppolAS2Version) {
        this.setPeppolAS2Version(ePeppolAS2Version);
        this.m_aHandlers = ServiceLoaderHelper.getAllSPIImplementations(IAS2IncomingSBDHandlerSPI.class);
        if (this.m_aHandlers.isEmpty()) {
            LOGGER.warn("No SPI handler of type " + IAS2IncomingSBDHandlerSPI.class.getName() + " for incoming SBD documents is registered. Therefore incoming documents will NOT be handled and maybe discarded if no other processors are active!");
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loaded " + this.m_aHandlers.size() + " IAS2IncomingSBDHandlerSPI implementations");
        }
    }

    @Nonnull
    public final EPeppolAS2Version getPeppolAS2Version() {
        return this.m_eAS2Version;
    }

    public final void setPeppolAS2Version(@Nonnull EPeppolAS2Version ePeppolAS2Version) {
        ValueEnforcer.notNull((Object)((Object)ePeppolAS2Version), (String)"AS2Version");
        this.m_eAS2Version = ePeppolAS2Version;
    }

    public boolean canHandle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) {
        return "store".equals(string) && iMessage instanceof AS2Message;
    }

    @Nullable
    private EndpointType _getReceiverEndpoint(@Nonnull String string, @Nullable IParticipantIdentifier iParticipantIdentifier, @Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable IProcessIdentifier iProcessIdentifier) throws AS2Exception {
        ISMPServiceMetadataProvider iSMPServiceMetadataProvider = AS2PeppolServletConfiguration.getSMPClient();
        if (iSMPServiceMetadataProvider == null) {
            throw new AS2Exception(string + "No SMP client configured!");
        }
        if (iParticipantIdentifier == null || iDocumentTypeIdentifier == null || iProcessIdentifier == null) {
            return null;
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string + "Looking up the endpoint of recipient " + iParticipantIdentifier.getURIEncoded() + " for " + iDocumentTypeIdentifier.getURIEncoded() + " and " + iProcessIdentifier.getURIEncoded() + " and " + this.m_eAS2Version.getTransportProfile());
            }
            return iSMPServiceMetadataProvider.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, this.m_eAS2Version.getTransportProfile());
        }
        catch (Throwable throwable) {
            throw new AS2Exception(string + "Failed to retrieve endpoint of recipient " + iParticipantIdentifier.getURIEncoded(), throwable);
        }
    }

    private static void _checkIfReceiverEndpointURLMatches(@Nonnull String string, @Nonnull EndpointType endpointType) throws AS2Exception {
        String string2 = AS2PeppolServletConfiguration.getAS2EndpointURL();
        if (StringHelper.hasNoText((String)string2)) {
            throw new AS2Exception(string + "The endpoint URL of this AP is not configured!");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "Our AP URL is " + string2);
        }
        String string3 = SMPClientReadOnly.getEndpointAddress((EndpointType)endpointType);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "Recipient AP URL is " + string3);
        }
        if (string3 == null || !string3.contains(string2)) {
            String string4 = string + " Internal error: The request is targeted for '" + string3 + "' and is not for us (" + string2 + ")";
            LOGGER.error(string4);
            throw new AS2Exception(string4);
        }
    }

    private static void _checkIfEndpointCertificateMatches(@Nonnull String string, @Nonnull EndpointType endpointType) throws AS2Exception {
        X509Certificate x509Certificate = AS2PeppolServletConfiguration.getAPCertificate();
        if (x509Certificate == null) {
            throw new AS2Exception(string + "The certificate of this AP is not configured!");
        }
        String string2 = endpointType.getCertificate();
        X509Certificate x509Certificate2 = null;
        try {
            x509Certificate2 = CertificateHelper.convertStringToCertficate((String)string2);
        }
        catch (CertificateException certificateException) {
            throw new AS2Exception(string + "Internal error: Failed to convert looked up endpoint certificate string '" + string2 + "' to an X.509 certificate!", (Throwable)certificateException);
        }
        if (x509Certificate2 == null) {
            throw new AS2Exception(string + "No certificate found in looked up endpoint! Is this AP maybe NOT contained in an SMP?");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "Conformant recipient certificate present: " + x509Certificate2.toString());
        }
        if (!x509Certificate.getSerialNumber().equals(x509Certificate2.getSerialNumber())) {
            String string3 = string + "Certificate retrieved from SMP lookup (" + x509Certificate2 + ") does not match this APs configured Certificate (" + x509Certificate + ") - different serial numbers - ignoring document";
            LOGGER.error(string3);
            throw new AS2Exception(string3);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "The certificate of the SMP lookup matches our certificate");
        }
    }

    public void handle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) throws AS2Exception {
        try {
            PeppolSBDHDocument peppolSBDHDocument;
            iMessage.partnership().setSigningAlgorithm(this.m_eAS2Version.getCryptoAlgorithmSign());
            iMessage.partnership().setVerifyUseCertificateInBodyPart(ETriState.TRUE);
            StandardBusinessDocument standardBusinessDocument = (StandardBusinessDocument)new SBDMarshaller().read(iMessage.getData().getInputStream());
            if (standardBusinessDocument == null) {
                throw new IllegalArgumentException("Failed to interpret the passed document as a Standard Business Document!");
            }
            if (AS2PeppolServletConfiguration.isReceiverCheckEnabled()) {
                peppolSBDHDocument = new PeppolSBDHDocumentReader().extractData(standardBusinessDocument);
                String string2 = "[" + peppolSBDHDocument.getInstanceIdentifier() + "] ";
                IAS2IncomingSBDHandlerSPI iAS2IncomingSBDHandlerSPI = this._getReceiverEndpoint(string2, peppolSBDHDocument.getReceiverAsIdentifier(), peppolSBDHDocument.getDocumentTypeAsIdentifier(), peppolSBDHDocument.getProcessAsIdentifier());
                if (iAS2IncomingSBDHandlerSPI == null) {
                    throw new AS2Exception((String)string2 + "Failed to resolve endpoint for provided receiver/documentType/process - not handling document");
                }
                AS2ServletSBDModule._checkIfReceiverEndpointURLMatches(string2, (EndpointType)iAS2IncomingSBDHandlerSPI);
                AS2ServletSBDModule._checkIfEndpointCertificateMatches(string2, (EndpointType)iAS2IncomingSBDHandlerSPI);
            } else {
                LOGGER.info("Endpoint checks for the AS2 AP are disabled");
            }
            peppolSBDHDocument = iMessage.headers().getClone();
            for (IAS2IncomingSBDHandlerSPI iAS2IncomingSBDHandlerSPI : this.m_aHandlers) {
                iAS2IncomingSBDHandlerSPI.handleIncomingSBD((HttpHeaderMap)peppolSBDHDocument, standardBusinessDocument);
            }
        }
        catch (Exception exception) {
            throw WrappedAS2Exception.wrap((Throwable)exception);
        }
    }
}

