/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.as2servlet;

import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.peppol.smp.ESMPTransportProfile;
import com.helger.peppol.smp.ISMPTransportProfile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EPeppolAS2Version implements IHasID<String>
{
    V1("v1", (ISMPTransportProfile)ESMPTransportProfile.TRANSPORT_PROFILE_AS2, ECryptoAlgorithmSign.DIGEST_SHA1),
    V2("v2", (ISMPTransportProfile)ESMPTransportProfile.TRANSPORT_PROFILE_AS2_V2, ECryptoAlgorithmSign.DIGEST_SHA_256);

    private final String m_sID;
    private final ISMPTransportProfile m_aTP;
    private final ECryptoAlgorithmSign m_eSigningAlgo;

    private EPeppolAS2Version(@Nonnull String string2, ISMPTransportProfile iSMPTransportProfile, ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        this.m_sID = string2;
        this.m_aTP = iSMPTransportProfile;
        this.m_eSigningAlgo = eCryptoAlgorithmSign;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public ISMPTransportProfile getTransportProfile() {
        return this.m_aTP;
    }

    @Nonnull
    public ECryptoAlgorithmSign getCryptoAlgorithmSign() {
        return this.m_eSigningAlgo;
    }

    @Nullable
    public static EPeppolAS2Version getFromIDOrNull(@Nullable String string) {
        return (EPeppolAS2Version)EnumHelper.getFromIDOrNull(EPeppolAS2Version.class, (Object)string);
    }
}

