/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.mail.cte.EContentTransferEncoding;
import jakarta.activation.DataHandler;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;

public class AS2ClientRequest {
    public static final String DEFAULT_CONTENT_TYPE = CMimeType.APPLICATION_XML.getAsString();
    private String m_sContentType = DEFAULT_CONTENT_TYPE;
    private final String m_sSubject;
    private byte[] m_aDataByteArray;
    private String m_sDataText;
    private Charset m_aDataCharset;
    private DataHandler m_aDataHandler;
    private String m_sFilename;
    private EContentTransferEncoding m_eCTE;
    private String m_sContentDescription;

    public AS2ClientRequest(@Nonnull @Nonempty String string) {
        this.m_sSubject = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Subject");
    }

    @Nonnull
    @Nonempty
    public String getSubject() {
        return this.m_sSubject;
    }

    @Nonnull
    public AS2ClientRequest setContentType(@Nonnull @Nonempty String string) {
        this.m_sContentType = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ContentType");
        return this;
    }

    @Nonnull
    @Nonempty
    public String getContentType() {
        return this.m_sContentType;
    }

    @Nonnull
    public AS2ClientRequest setData(@Nonnull File file, @Nullable Charset charset) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        this.setData(FileHelper.getInputStream((File)file), charset);
        this.setFilename(file.getName());
        return this;
    }

    @Nonnull
    public AS2ClientRequest setData(@Nonnull @WillClose InputStream inputStream) {
        return this.setData(inputStream, (Charset)null);
    }

    @Nonnull
    public AS2ClientRequest setData(@Nonnull @WillClose InputStream inputStream, @Nullable Charset charset) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        byte[] byArray = StreamHelper.getAllBytes((InputStream)inputStream);
        if (charset == null) {
            return this.setData(byArray);
        }
        return this.setData(new String(byArray, charset), charset);
    }

    @Nonnull
    public AS2ClientRequest setData(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull((Object)byArray, (String)"Data");
        this.m_aDataByteArray = byArray;
        this.m_sDataText = null;
        this.m_aDataCharset = null;
        this.m_aDataHandler = null;
        this.m_sContentType = CMimeType.APPLICATION_OCTET_STREAM.getAsStringWithoutParameters();
        return this;
    }

    @Nonnull
    public AS2ClientRequest setData(@Nonnull String string, @Nullable Charset charset) {
        ValueEnforcer.notNull((Object)string, (String)"Text");
        this.m_aDataByteArray = null;
        this.m_sDataText = string;
        this.m_aDataCharset = charset;
        this.m_aDataHandler = null;
        this.m_sContentType = CMimeType.TEXT_PLAIN.getAsStringWithoutParameters();
        return this;
    }

    @Nonnull
    public AS2ClientRequest setData(@Nonnull DataHandler dataHandler) {
        ValueEnforcer.notNull((Object)dataHandler, (String)"DataHandler");
        this.m_aDataByteArray = null;
        this.m_sDataText = null;
        this.m_aDataCharset = null;
        this.m_aDataHandler = dataHandler;
        this.m_sContentType = dataHandler.getContentType();
        return this;
    }

    @Nonnull
    public AS2ClientRequest setFilename(@Nullable String string) {
        this.m_sFilename = string;
        return this;
    }

    @Nonnull
    public AS2ClientRequest setContentTransferEncoding(@Nullable EContentTransferEncoding eContentTransferEncoding) {
        this.m_eCTE = eContentTransferEncoding;
        return this;
    }

    @Nullable
    public EContentTransferEncoding getContentTransferEncoding() {
        return this.m_eCTE;
    }

    @Nonnull
    public AS2ClientRequest setContentDescription(@Nullable String string) {
        this.m_sContentDescription = string;
        return this;
    }

    public void applyDataOntoMimeBodyPart(@Nonnull MimeBodyPart mimeBodyPart) throws MessagingException {
        if (this.m_aDataByteArray != null) {
            mimeBodyPart.setDataHandler(new DataHandler((Object)this.m_aDataByteArray, this.m_sContentType));
        } else if (this.m_sDataText != null) {
            mimeBodyPart.setText(this.m_sDataText, this.m_aDataCharset == null ? null : this.m_aDataCharset.name());
        } else if (this.m_aDataHandler != null) {
            mimeBodyPart.setDataHandler(this.m_aDataHandler);
        } else {
            throw new IllegalStateException("No data specified in AS2 client request! A call to setData is missing.");
        }
        if (this.m_sFilename != null) {
            mimeBodyPart.setFileName(this.m_sFilename);
        }
        if (mimeBodyPart.getHeader("Content-Type") == null) {
            mimeBodyPart.setHeader("Content-Type", this.m_sContentType != null ? this.m_sContentType : CMimeType.APPLICATION_OCTET_STREAM.getAsStringWithoutParameters());
        }
        if (this.m_eCTE != null) {
            mimeBodyPart.setHeader("Content-Transfer-Encoding", this.m_eCTE.getID());
        }
        if (StringHelper.hasText((String)this.m_sContentDescription)) {
            mimeBodyPart.setHeader("Content-Description", this.m_sContentDescription);
        }
    }
}

