/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.crypto;

import com.helger.as2lib.crypto.ICryptoAlgorithm;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

public enum ECryptoAlgorithmSign implements ICryptoAlgorithm
{
    DIGEST_RSA_MD5("rsa-md5", "md5", PKCSObjectIdentifiers.md5, "MD5WITHRSA"),
    DIGEST_RSA_SHA1("rsa-sha1", "sha1", OIWObjectIdentifiers.idSHA1, "SHA1WITHRSA"),
    DIGEST_MD5("md5", "md5", PKCSObjectIdentifiers.md5, "MD5WITHRSA"),
    DIGEST_SHA1("sha1", "sha1", OIWObjectIdentifiers.idSHA1, "SHA1WITHRSA"),
    DIGEST_SHA256("sha256", "sha256", NISTObjectIdentifiers.id_sha256, "SHA256WITHRSA"),
    DIGEST_SHA384("sha384", "sha384", NISTObjectIdentifiers.id_sha384, "SHA384WITHRSA"),
    DIGEST_SHA512("sha512", "sha512", NISTObjectIdentifiers.id_sha512, "SHA512WITHRSA"),
    DIGEST_SHA_1("sha-1", "sha-1", OIWObjectIdentifiers.idSHA1, "SHA1WITHRSA"),
    DIGEST_SHA_224("sha-224", "sha-224", NISTObjectIdentifiers.id_sha224, "SHA224WITHRSA"),
    DIGEST_SHA_256("sha-256", "sha-256", NISTObjectIdentifiers.id_sha256, "SHA256WITHRSA"),
    DIGEST_SHA_384("sha-384", "sha-384", NISTObjectIdentifiers.id_sha384, "SHA384WITHRSA"),
    DIGEST_SHA_512("sha-512", "sha-512", NISTObjectIdentifiers.id_sha512, "SHA512WITHRSA"),
    RSASSA_PSS_WITH_SHA224("rsassa-pss-sha-224", "sha-224", NISTObjectIdentifiers.id_sha224, "SHA224WITHRSAANDMGF1"),
    RSASSA_PSS_WITH_SHA256("rsassa-pss-sha-256", "sha-256", NISTObjectIdentifiers.id_sha256, "SHA256WITHRSAANDMGF1"),
    RSASSA_PSS_WITH_SHA384("rsassa-pss-sha-384", "sha-384", NISTObjectIdentifiers.id_sha384, "SHA384WITHRSAANDMGF1"),
    RSASSA_PSS_WITH_SHA512("rsassa-pss-sha-512", "sha-512", NISTObjectIdentifiers.id_sha512, "SHA512WITHRSAANDMGF1"),
    RSASSA_PSS_WITH_SHA3_224("rsassa-pss-sha3-224", "sha3-224", NISTObjectIdentifiers.id_sha3_224, "SHA3-224WITHRSAANDMGF1"),
    RSASSA_PSS_WITH_SHA3_256("rsassa-pss-sha3-256", "sha3-256", NISTObjectIdentifiers.id_sha3_256, "SHA3-256WITHRSAANDMGF1"),
    RSASSA_PSS_WITH_SHA3_384("rsassa-pss-sha3-384", "sha3-384", NISTObjectIdentifiers.id_sha3_384, "SHA3-384WITHRSAANDMGF1"),
    RSASSA_PSS_WITH_SHA3_512("rsassa-pss-sha3-512", "sha3-512", NISTObjectIdentifiers.id_sha3_512, "SHA3-512WITHRSAANDMGF1");

    public static final ECryptoAlgorithmSign DEFAULT_RFC_3851;
    public static final ECryptoAlgorithmSign DEFAULT_RFC_5751;
    private final String m_sID;
    private final String m_sMicAlgID;
    private final ASN1ObjectIdentifier m_aDigestOID;
    private final String m_sBCAlgorithmName;

    private ECryptoAlgorithmSign(@Nonnull String string2, @Nonnull @Nonempty String string3, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string4) {
        this.m_sID = string2;
        this.m_sMicAlgID = string3;
        this.m_aDigestOID = aSN1ObjectIdentifier;
        this.m_sBCAlgorithmName = string4;
        new DefaultSignatureAlgorithmIdentifierFinder().find(string4);
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getMICAlgorithmID() {
        return this.m_sMicAlgID;
    }

    @Override
    @Nonnull
    public ASN1ObjectIdentifier getOID() {
        return this.m_aDigestOID;
    }

    @Nonnull
    @Nonempty
    public String getSignAlgorithmName() {
        return this.m_sBCAlgorithmName;
    }

    public boolean isRFC3851Algorithm() {
        return this == DIGEST_RSA_MD5 || this == DIGEST_RSA_SHA1 || this == DIGEST_MD5 || this == DIGEST_SHA1 || this == DIGEST_SHA256 || this == DIGEST_SHA384 || this == DIGEST_SHA512;
    }

    public boolean isRFC5751Algorithm() {
        return this == DIGEST_MD5 || this == DIGEST_SHA_1 || this == DIGEST_SHA_256 || this == DIGEST_SHA_384 || this == DIGEST_SHA_512;
    }

    @Nullable
    public static ECryptoAlgorithmSign getFromIDOrNull(@Nullable String string) {
        return (ECryptoAlgorithmSign)EnumHelper.getFromIDCaseInsensitiveOrNull(ECryptoAlgorithmSign.class, (String)string);
    }

    @Nonnull
    public static ECryptoAlgorithmSign getFromIDOrThrow(@Nullable String string) {
        return (ECryptoAlgorithmSign)EnumHelper.getFromIDCaseInsensitiveOrThrow(ECryptoAlgorithmSign.class, (String)string);
    }

    @Nullable
    public static ECryptoAlgorithmSign getFromIDOrDefault(@Nullable String string, @Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        return (ECryptoAlgorithmSign)EnumHelper.getFromIDCaseInsensitiveOrDefault(ECryptoAlgorithmSign.class, (String)string, (Enum)eCryptoAlgorithmSign);
    }

    static {
        DEFAULT_RFC_3851 = DIGEST_SHA1;
        DEFAULT_RFC_5751 = DIGEST_SHA_256;
    }
}

