/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.message;

import com.helger.as2lib.message.AbstractMessage;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.params.CompositeParameters;
import com.helger.as2lib.params.DateParameters;
import com.helger.as2lib.params.MessageParameters;
import com.helger.as2lib.params.RandomParameters;
import com.helger.commons.annotation.Nonempty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS2Message
extends AbstractMessage {
    public static final String ATTRIBUTE_RECEIVED = "as2msg.received";
    public static final String ATTRIBUTE_RECEIVED_ENCRYPTED = "as2msg.received.encrypted";
    public static final String ATTRIBUTE_RECEIVED_SIGNED = "as2msg.received.signed";
    public static final String ATTRIBUTE_RECEIVED_SIGNATURE_CERTIFICATE = "as2msg.received.signature.certificate";
    public static final String ATTRIBUTE_RECEIVED_COMPRESSED = "as2msg.received.compressed";
    public static final String ATTRIBUTE_MIC = "MIC";
    public static final String PROTOCOL_AS2 = "as2";
    public static final String DEFAULT_ID_FORMAT = "as2-lib-$date.ddMMuuuuHHmmssZ$-$rand.1234$@$msg.sender.as2_id$_$msg.receiver.as2_id$";

    @Override
    @Nonnull
    @Nonempty
    public final String getProtocol() {
        return PROTOCOL_AS2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String generateMessageID() {
        CompositeParameters compositeParameters = new CompositeParameters(false).add("date", new DateParameters()).add("msg", new MessageParameters(this)).add("rand", new RandomParameters());
        String string = this.partnership().getMessageIDFormat(DEFAULT_ID_FORMAT);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        try {
            stringBuilder.append(compositeParameters.format(string));
        }
        catch (AS2InvalidParameterException aS2InvalidParameterException) {
            stringBuilder.append(string);
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    @Override
    public boolean isRequestingMDN() {
        if (this.partnership().getAS2MDNTo() != null) {
            return true;
        }
        return this.containsHeader("Disposition-Notification-To");
    }

    @Override
    public boolean isRequestingAsynchMDN() {
        if (this.partnership().getAS2MDNTo() != null && this.partnership().getAS2ReceiptDeliveryOption() != null) {
            return true;
        }
        return this.containsHeader("Disposition-Notification-To") && this.containsHeader("Receipt-Delivery-Option");
    }

    @Nullable
    public String getAsyncMDNurl() {
        return this.getHeader("Receipt-Delivery-Option");
    }
}

