/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor;

import com.helger.as2lib.AbstractDynamicComponent;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.processor.AS2NoModuleException;
import com.helger.as2lib.processor.AS2ProcessorException;
import com.helger.as2lib.processor.IMessageProcessor;
import com.helger.as2lib.processor.module.IProcessorActiveModule;
import com.helger.as2lib.processor.module.IProcessorModule;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageProcessor
extends AbstractDynamicComponent
implements IMessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageProcessor.class);
    private final ICommonsList<IProcessorModule> m_aModules = new CommonsArrayList();

    protected AbstractMessageProcessor() {
    }

    @Override
    public void addModule(@Nonnull IProcessorModule iProcessorModule) {
        ValueEnforcer.notNull((Object)iProcessorModule, (String)"Module");
        this.m_aModules.add((Object)iProcessorModule);
    }

    @Override
    @Nonnull
    public EChange removeModule(@Nullable IProcessorModule iProcessorModule) {
        if (iProcessorModule == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aModules.removeObject((Object)iProcessorModule);
    }

    @Override
    @Nonnegative
    public int getModuleCount() {
        return this.m_aModules.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IProcessorModule> getAllModules() {
        return (ICommonsList)this.m_aModules.getClone();
    }

    @Override
    @Nullable
    public <T extends IProcessorModule> T getModuleOfClass(@Nonnull Class<T> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        return (T)((IProcessorModule)this.m_aModules.findFirstMapped(iProcessorModule -> clazz.isAssignableFrom(iProcessorModule.getClass()), clazz::cast));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public <T extends IProcessorModule> ICommonsList<T> getAllModulesOfClass(@Nonnull Class<T> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        return this.m_aModules.getAllInstanceOf(clazz);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IProcessorActiveModule> getAllActiveModules() {
        return this.m_aModules.getAllInstanceOf(IProcessorActiveModule.class);
    }

    @Override
    public void startActiveModules() {
        for (IProcessorActiveModule iProcessorActiveModule : this.getAllActiveModules()) {
            try {
                iProcessorActiveModule.start();
            }
            catch (AS2Exception aS2Exception) {
                aS2Exception.terminate();
            }
        }
    }

    @Override
    public void stopActiveModules() {
        for (IProcessorActiveModule iProcessorActiveModule : this.getAllActiveModules()) {
            try {
                iProcessorActiveModule.stop();
            }
            catch (AS2Exception aS2Exception) {
                aS2Exception.terminate();
            }
        }
    }

    protected final void executeAction(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) throws AS2Exception {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  handling action '" + string + "' on message '" + iMessage.getMessageID() + "' with options " + map);
        }
        ICommonsList<IProcessorModule> iCommonsList = this.getAllModules();
        for (IProcessorModule iProcessorModule : iCommonsList) {
            if (iProcessorModule.canHandle(string, iMessage, map)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("  handling action '" + string + "' with module " + iProcessorModule);
                }
                try {
                    commonsArrayList2.add((Object)iProcessorModule);
                    iProcessorModule.handle(string, iMessage, map);
                }
                catch (AS2Exception aS2Exception) {
                    commonsArrayList.add((Object)aS2Exception);
                }
                continue;
            }
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("  Not handling action '" + string + "' with module " + iProcessorModule);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  action '" + string + "' was handled by modules: " + (ICommonsList)commonsArrayList2);
        }
        if (commonsArrayList.isNotEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  action '" + string + "' was handled but failed: " + (ICommonsList)commonsArrayList);
            }
            throw new AS2ProcessorException(this, (List<? extends AS2Exception>)commonsArrayList);
        }
        if (commonsArrayList2.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  no modules found for '" + string + "'; modules are: " + iCommonsList);
            }
            throw new AS2NoModuleException(string, iMessage, map);
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

