/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.module;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.AS2UnsupportedException;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.processor.module.AS2ForcedStopException;
import com.helger.as2lib.processor.module.AbstractProcessorModule;
import com.helger.as2lib.processor.module.IProcessorActiveModule;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.string.ToStringGenerator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractActiveModule
extends AbstractProcessorModule
implements IProcessorActiveModule {
    private final AtomicBoolean m_aRunning = new AtomicBoolean(false);

    @Override
    public final boolean isRunning() {
        return this.m_aRunning.get();
    }

    private void _setRunning(boolean bl) {
        this.m_aRunning.set(bl);
    }

    @Override
    @OverrideOnDemand
    public boolean canHandle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) {
        return false;
    }

    @Override
    public void handle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) throws AS2Exception {
        throw new AS2UnsupportedException("Active modules don't handle anything by default");
    }

    public void forceStop(@Nullable Exception exception) {
        new AS2ForcedStopException(exception).terminate();
        try {
            this.stop();
        }
        catch (AS2Exception aS2Exception) {
            aS2Exception.terminate();
        }
    }

    public abstract void doStart() throws AS2Exception;

    @Override
    public void start() throws AS2Exception {
        this._setRunning(true);
        this.doStart();
    }

    public abstract void doStop() throws AS2Exception;

    @Override
    public void stop() throws AS2Exception {
        this._setRunning(false);
        this.doStop();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Running", this.isRunning()).getToString();
    }
}

