/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.receiver;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.params.CompositeParameters;
import com.helger.as2lib.params.DateParameters;
import com.helger.as2lib.params.MessageParameters;
import com.helger.as2lib.processor.receiver.AS2InvalidMessageException;
import com.helger.as2lib.processor.receiver.AbstractActiveReceiverModule;
import com.helger.as2lib.processor.receiver.net.INetModuleHandler;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.StringHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActiveNetModule
extends AbstractActiveReceiverModule {
    public static final String ATTR_ADDRESS = "address";
    public static final String ATTR_PORT = "port";
    public static final String ATTR_ERROR_DIRECTORY = "errordir";
    public static final String ATTR_ERROR_FORMAT = "errorformat";
    public static final String DEFAULT_ERROR_FORMAT = "$date.uuuuMMddhhmmss$";
    public static final String ATTR_ERROR_STORE_BODY = "errorstorebody";
    public static final String ATTR_QUOTE_HEADER_VALUES = "quoteheadervalues";
    public static final boolean DEFAULT_QUOTE_HEADER_VALUES = false;
    public static final String MSG_SENDER = "$sender.as2_id$";
    public static final String MSG_RECEIVER = "$receiver.as2_id$";
    public static final String MSG_DATE = "$headers.date$";
    public static final String MSG_SUBJECT = "$headers.subject$";
    public static final String MSG_SOURCE_ADDRESS = "$attributes.source_ip$";
    public static final String DP_HEADER = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, ";
    public static final String DP_DECRYPTED = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. ";
    public static final String DP_VERIFIED = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message. ";
    public static final String DISP_PARTNERSHIP_NOT_FOUND = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but the Sender $sender.as2_id$ and/or Recipient $receiver.as2_id$ are unknown.";
    public static final String DISP_PARSING_MIME_FAILED = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured while parsing the MIME content.";
    public static final String DISP_DECRYPTION_ERROR = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decrypting the content.";
    public static final String DISP_DECOMPRESSION_ERROR = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, but an error occured decompressing the content.";
    public static final String DISP_VERIFY_SIGNATURE_FAILED = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. Authentication of the originator of the message failed.";
    public static final String DISP_VALIDATION_FAILED = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message. An error occured while validating the received data.";
    public static final String DISP_STORAGE_FAILED = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message. An error occured while storing the data to the file system.";
    public static final String DISP_SUCCESS = "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message. There is no guarantee however that the EDI Interchange was syntactically correct, or was received by the EDI application/translator.";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractActiveNetModule.class);
    private MainThread m_aMainThread;

    @Nullable
    public final String getAddress() {
        return this.attrs().getAsString((Object)ATTR_ADDRESS);
    }

    public final void setAddress(@Nullable String string) {
        if (string == null) {
            this.attrs().remove((Object)ATTR_ADDRESS);
        } else {
            this.attrs().putIn((Object)ATTR_ADDRESS, (Object)string);
        }
    }

    public final int getPort() {
        return this.attrs().getAsInt((Object)ATTR_PORT, 0);
    }

    public final void setPort(int n) {
        if (n < 0) {
            this.attrs().remove((Object)ATTR_PORT);
        } else {
            this.attrs().putIn(ATTR_PORT, n);
        }
    }

    @Nullable
    public final String getErrorDirectory() {
        return this.attrs().getAsString((Object)ATTR_ERROR_DIRECTORY);
    }

    public final void setErrorDirectory(@Nullable String string) {
        if (string == null) {
            this.attrs().remove((Object)ATTR_ERROR_DIRECTORY);
        } else {
            this.attrs().putIn((Object)ATTR_ERROR_DIRECTORY, (Object)string);
        }
    }

    @Nonnull
    public final String getErrorFormat() {
        return this.attrs().getAsString((Object)ATTR_ERROR_FORMAT, DEFAULT_ERROR_FORMAT);
    }

    public final void setErrorFormat(@Nullable String string) {
        if (string == null) {
            this.attrs().remove((Object)ATTR_ERROR_FORMAT);
        } else {
            this.attrs().putIn((Object)ATTR_ERROR_FORMAT, (Object)string);
        }
    }

    public final boolean isErrorStoreBody() {
        return this.attrs().getAsBoolean((Object)ATTR_ERROR_STORE_BODY, false);
    }

    public final void setErrorStoreBody(boolean bl) {
        this.attrs().putIn(ATTR_ERROR_STORE_BODY, bl);
    }

    public final boolean isQuoteHeaderValues() {
        return this.attrs().getAsBoolean((Object)ATTR_QUOTE_HEADER_VALUES, false);
    }

    public final void setQuoteHeaderValues(boolean bl) {
        this.attrs().putIn(ATTR_QUOTE_HEADER_VALUES, bl);
    }

    @Override
    public void doStart() throws AS2Exception {
        try {
            String string = this.getAddress();
            int n = this.getPort();
            this.m_aMainThread = new MainThread(this, string, n);
            this.m_aMainThread.setUncaughtExceptionHandler(BasicThreadFactory.getDefaultUncaughtExceptionHandler());
            this.m_aMainThread.start();
        }
        catch (IOException iOException) {
            throw WrappedAS2Exception.wrap(iOException);
        }
    }

    @Override
    public void doStop() throws AS2Exception {
        if (this.m_aMainThread != null) {
            this.m_aMainThread.terminate();
            this.m_aMainThread = null;
        }
    }

    @Nonnull
    public abstract INetModuleHandler createHandler();

    public void handleError(@Nonnull IMessage iMessage, @Nonnull AS2Exception aS2Exception) {
        block12: {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Handling error in " + ClassHelper.getClassLocalName(this.getClass()) + " for message with ID " + iMessage.getMessageID() + " and exception " + ClassHelper.getClassLocalName(aS2Exception.getClass()) + " with error " + aS2Exception.getMessage());
            }
            aS2Exception.terminate(iMessage);
            try {
                CompositeParameters compositeParameters = new CompositeParameters(false).add("date", new DateParameters()).add("msg", new MessageParameters(iMessage));
                String string = compositeParameters.format(this.getErrorFormat());
                String string2 = compositeParameters.format(this.getErrorDirectory());
                if (StringHelper.hasText((String)string2)) {
                    File file = AS2IOHelper.getUniqueFile(AS2IOHelper.getDirectoryFile(string2), FilenameHelper.getAsSecureValidFilename((String)string));
                    boolean bl = this.isErrorStoreBody();
                    try (FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)file);){
                        String string3 = iMessage.getAsString();
                        ((OutputStream)fileOutputStream).write(string3.getBytes());
                        if (bl) {
                            StreamHelper.copyInputStreamToOutputStream((InputStream)iMessage.getData().getInputStream(), (OutputStream)fileOutputStream);
                        }
                    }
                    new AS2InvalidMessageException("Stored invalid message to " + file.getAbsolutePath()).terminate();
                    break block12;
                }
                LOGGER.warn("No error directory present, so ignoring the error");
            }
            catch (Exception exception) {
                WrappedAS2Exception.wrap(exception).terminate(iMessage);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    protected static class MainThread
    extends Thread {
        private final AbstractActiveNetModule m_aOwner;
        private final ServerSocket m_aServerSocket;
        private volatile boolean m_bTerminated;

        public MainThread(@Nonnull AbstractActiveNetModule abstractActiveNetModule, @Nullable String string, @Nonnegative int n) throws IOException {
            super("AS2MainThread-" + ClassHelper.getClassLocalName((Object)abstractActiveNetModule));
            this.m_aOwner = abstractActiveNetModule;
            this.m_aServerSocket = new ServerSocket();
            InetSocketAddress inetSocketAddress = string == null ? new InetSocketAddress(n) : new InetSocketAddress(string, n);
            this.m_aServerSocket.bind(inetSocketAddress);
            LOGGER.info("Inited " + this.getName() + " at " + inetSocketAddress);
        }

        @OverrideOnDemand
        protected Socket createAcceptSocket() throws IOException {
            Socket socket = this.m_aServerSocket.accept();
            socket.setSoLinger(true, 60);
            return socket;
        }

        @Override
        public void run() {
            LOGGER.info("AS2MainThread: run");
            while (!this.m_bTerminated && !this.isInterrupted()) {
                try {
                    Socket socket = this.createAcceptSocket();
                    new ConnectionThread(this.m_aOwner, socket).start();
                }
                catch (Exception exception) {
                    if (this.m_bTerminated) continue;
                    this.m_aOwner.forceStop(exception);
                }
            }
            LOGGER.info("AS2MainThread: done running");
        }

        public void terminate() {
            if (!this.m_bTerminated) {
                this.m_bTerminated = true;
                if (this.m_aServerSocket != null) {
                    try {
                        this.m_aServerSocket.close();
                    }
                    catch (IOException iOException) {
                        this.m_aOwner.forceStop(iOException);
                    }
                }
            }
        }
    }

    protected static final class ConnectionThread
    extends Thread {
        private final AbstractActiveNetModule m_aOwner;
        private final Socket m_aSocket;

        public ConnectionThread(@Nonnull AbstractActiveNetModule abstractActiveNetModule, @Nonnull @WillClose Socket socket) {
            super("AS2ConnectionThread-" + ClassHelper.getClassLocalName((Object)abstractActiveNetModule));
            this.m_aOwner = abstractActiveNetModule;
            this.m_aSocket = socket;
        }

        @Override
        public void run() {
            LOGGER.info("AS2ConnectionThread: run");
            this.m_aOwner.createHandler().handle(this.m_aOwner, this.m_aSocket);
            try {
                this.m_aSocket.close();
            }
            catch (IOException iOException) {
                WrappedAS2Exception.wrap(iOException).terminate();
            }
            finally {
                LOGGER.info("AS2ConnectionThread: done running");
            }
        }
    }
}

