/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.sender;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.partner.Partnership;
import com.helger.as2lib.processor.module.AbstractProcessorModule;
import com.helger.as2lib.processor.sender.IProcessorSenderModule;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.string.StringParser;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSenderModule
extends AbstractProcessorModule
implements IProcessorSenderModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSenderModule.class);

    @Nonnegative
    protected final int getRetryCount(@Nullable Partnership partnership, @Nullable Map<String, Object> map) {
        String string;
        int n;
        int n2 = -1;
        if (partnership != null && (n = StringParser.parseInt((String)(string = partnership.getAttribute("retries")), (int)-1)) >= 0) {
            n2 = n;
        }
        if (map != null && (n = StringParser.parseInt((String)(string = (String)map.get("retries")), (int)-1)) >= 0) {
            n2 = n2 < 0 ? n : Math.min(n2, n);
        }
        if ((n = StringParser.parseInt((String)(string = this.attrs().getAsString((Object)"retries")), (int)-1)) >= 0) {
            n2 = n2 < 0 ? n : Math.min(n2, n);
        }
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    protected final boolean doResend(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable AS2Exception aS2Exception, int n) throws AS2Exception {
        if (n <= 0) {
            LOGGER.info("Retry count exceeded - no more retries for" + iMessage.getLoggingText());
            return false;
        }
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        commonsHashMap.put((Object)"cause", (Object)aS2Exception);
        commonsHashMap.put((Object)"initial_sender", (Object)this);
        commonsHashMap.put((Object)"resend_method", (Object)string);
        commonsHashMap.put((Object)"retries", (Object)Integer.toString(n));
        this.getSession().getMessageProcessor().handle("resend", iMessage, (Map<String, Object>)commonsHashMap);
        LOGGER.info("Scheduled message for resending" + iMessage.getLoggingText());
        return true;
    }
}

