/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.storage;

import com.helger.as2lib.disposition.AS2DispositionException;
import com.helger.as2lib.disposition.DispositionType;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.params.CompositeParameters;
import com.helger.as2lib.params.DateParameters;
import com.helger.as2lib.params.MessageParameters;
import com.helger.as2lib.processor.storage.AbstractStorageModule;
import com.helger.commons.io.stream.StringInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFileModule
extends AbstractStorageModule {
    public static final String ATTR_HEADER = "header";
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageFileModule.class);

    public MessageFileModule() {
        super("store");
    }

    @Nullable
    public final String getHeaderFilename() {
        return this.attrs().getAsString((Object)ATTR_HEADER);
    }

    public final void setHeaderFilename(@Nullable String string) {
        if (string == null) {
            this.attrs().remove((Object)ATTR_HEADER);
        } else {
            this.attrs().putIn((Object)ATTR_HEADER, (Object)string);
        }
    }

    @Override
    public void handle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) throws AS2Exception {
        Object object;
        Object object2;
        try {
            object2 = this.getFile(iMessage, this.getAttributeAsStringRequired("filename"));
            object = iMessage.getData().getInputStream();
            try {
                this.store((File)object2, (InputStream)object);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            iMessage.attrs().put((Object)"storedfilename", (Object)((File)object2).getAbsolutePath());
            LOGGER.info("stored message to " + ((File)object2).getAbsolutePath() + iMessage.getLoggingText());
        }
        catch (AS2DispositionException aS2DispositionException) {
            throw aS2DispositionException;
        }
        catch (Exception exception) {
            throw AS2DispositionException.wrap(exception, () -> DispositionType.createError("error-storing-transaction"), () -> "The message sent to Recipient $receiver.as2_id$ on $headers.date$ with Subject $headers.subject$ has been received, the EDI Interchange was successfully decrypted and it's integrity was verified. In addition, the sender of the message, Sender $sender.as2_id$ at Location $attributes.source_ip$ was authenticated as the originator of the message. An error occured while storing the data to the file system.");
        }
        object2 = this.getHeaderFilename();
        if (object2 != null) {
            try {
                object = this.getFile(iMessage, (String)object2);
                try (InputStream inputStream = MessageFileModule.getHeaderStream(iMessage, this.getCharset());){
                    this.store((File)object, inputStream);
                }
                LOGGER.info("stored headers to " + ((File)object).getAbsolutePath() + iMessage.getLoggingText());
            }
            catch (IOException iOException) {
                throw WrappedAS2Exception.wrap(iOException);
            }
        }
    }

    @Override
    @Nonnull
    protected String getFilename(@Nonnull IMessage iMessage, @Nullable String string) throws AS2InvalidParameterException {
        CompositeParameters compositeParameters = new CompositeParameters(false).add("date", new DateParameters()).add("msg", new MessageParameters(iMessage));
        return compositeParameters.format(string);
    }

    @Nonnull
    protected static InputStream getHeaderStream(@Nonnull IMessage iMessage, @Nonnull Charset charset) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Message Headers:").append("\r\n");
        iMessage.headers().forEachHeaderLine(string -> stringBuilder.append((String)string).append("\r\n"), true);
        stringBuilder.append("\r\n");
        stringBuilder.append("Attributes:").append("\r\n");
        for (Map.Entry entry : iMessage.attrs().entrySet()) {
            stringBuilder.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\r\n");
        }
        return new StringInputStream(stringBuilder.toString(), charset);
    }
}

