/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util;

import com.helger.commons.codec.RFC2616Codec;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.string.StringHelper;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AS2HttpHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2HttpHelper.class);

    private AS2HttpHelper() {
    }

    @Nullable
    public static ContentType parseContentType(@Nullable String string) {
        block3: {
            if (StringHelper.hasText((String)string)) {
                String string2 = RFC2616Codec.isMaybeEncoded((String)string) ? new RFC2616Codec().getDecodedAsString(string) : string;
                try {
                    return new ContentType(string2);
                }
                catch (ParseException parseException) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Error parsing Content-Type '" + string + "'", (Throwable)parseException);
                }
            }
        }
        return null;
    }

    @Nullable
    public static String getCleanContentType(@Nullable String string) {
        ContentType contentType = AS2HttpHelper.parseContentType(string);
        return contentType != null ? contentType.toString() : null;
    }

    @Nonnull
    public static InternetHeaders getAsInternetHeaders(@Nonnull HttpHeaderMap httpHeaderMap) {
        InternetHeaders internetHeaders = new InternetHeaders();
        httpHeaderMap.forEachSingleHeader((arg_0, arg_1) -> ((InternetHeaders)internetHeaders).addHeader(arg_0, arg_1), false, false);
        return internetHeaders;
    }
}

